/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.HashSet;
import java.util.Set;
import org.openvpms.etl.load.LookupDescriptor;
import org.openvpms.etl.load.Pair;

public class LookupRelationshipDescriptor {
    private final String archetype;
    private final LookupDescriptor source;
    private final LookupDescriptor target;
    private final Set<Pair> pairs = new HashSet<Pair>();

    public LookupRelationshipDescriptor(String archetype, LookupDescriptor source, LookupDescriptor target) {
        this.archetype = archetype;
        this.source = source;
        this.target = target;
    }

    public String getArchetype() {
        return this.archetype;
    }

    public LookupDescriptor getSource() {
        return this.source;
    }

    public LookupDescriptor getTarget() {
        return this.target;
    }

    public void add(String sourceCode, String targetCode) {
        this.pairs.add(new Pair(sourceCode, targetCode));
    }

    public Set<Pair> getPairs() {
        return this.pairs;
    }

    public void clear() {
        this.pairs.clear();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LookupRelationshipDescriptor)) {
            return false;
        }
        LookupRelationshipDescriptor object = (LookupRelationshipDescriptor)other;
        return this.archetype.equals(object.archetype);
    }

    public int hashCode() {
        return this.archetype.hashCode();
    }
}

