/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import junit.framework.TestCase;
import org.junit.Test;
import org.openvpms.etl.load.Node;
import org.openvpms.etl.load.NodeParser;

public class NodeParserTestCase
extends TestCase {
    @Test
    public void testSingleNode() {
        Node node = NodeParser.parse((String)"<party.customerperson>firstName");
        this.checkNode(node, null, "party.customerperson", "firstName", -1);
        NodeParserTestCase.assertEquals((String)"<party.customerperson>firstName", (String)node.getNodePath());
        NodeParserTestCase.assertEquals((String)"<party.customerperson>", (String)node.getObjectPath());
    }

    @Test
    public void testCollectionNode() {
        Node node = NodeParser.parse((String)"<party.customerperson>contacts[0]<contact.location>address");
        this.checkNode(node, null, "party.customerperson", "contacts", 0);
        this.checkNode(node.getChild(), null, "contact.location", "address", -1);
        NodeParserTestCase.assertEquals((String)"<party.customerperson>contacts[0]", (String)node.getNodePath());
        NodeParserTestCase.assertEquals((String)"<party.customerperson>", (String)node.getObjectPath());
        NodeParserTestCase.assertEquals((String)"<party.customerperson>contacts[0]<contact.location>address", (String)node.getChild().getNodePath());
        NodeParserTestCase.assertEquals((String)"<party.customerperson>contacts[0]<contact.location>", (String)node.getChild().getObjectPath());
    }

    @Test
    public void testReferenceNode() {
        Node node = NodeParser.parse((String)"$ROWID<party.customerperson>firstName");
        this.checkNode(node, "ROWID", "party.customerperson", "firstName", -1);
        NodeParserTestCase.assertEquals((String)"$ROWID<party.customerperson>firstName", (String)node.getNodePath());
        NodeParserTestCase.assertEquals((String)"$ROWID<party.customerperson>", (String)node.getObjectPath());
    }

    @Test
    public void testInvalid() {
        NodeParserTestCase.assertNull((Object)NodeParser.parse((String)""));
        NodeParserTestCase.assertNull((Object)NodeParser.parse((String)"<party.customerperson>"));
        NodeParserTestCase.assertNull((Object)NodeParser.parse((String)"<party.customerperson>[0]"));
        NodeParserTestCase.assertNull((Object)NodeParser.parse((String)"<party.customerperson>xnode[0]ynode"));
        NodeParserTestCase.assertNull((Object)NodeParser.parse((String)"$ROWID"));
        NodeParserTestCase.assertNull((Object)NodeParser.parse((String)"<party.customerperson>contacts[0]$ROWID<contact.location>address"));
    }

    private void checkNode(Node node, String field, String archetype, String name, int index) {
        NodeParserTestCase.assertNotNull((Object)node);
        NodeParserTestCase.assertEquals((String)field, (String)node.getField());
        NodeParserTestCase.assertEquals((String)archetype, (String)node.getArchetype());
        NodeParserTestCase.assertEquals((String)name, (String)node.getName());
        NodeParserTestCase.assertEquals((int)index, (int)node.getIndex());
        if (index == -1) {
            NodeParserTestCase.assertNull((Object)node.getChild());
        }
    }
}

