/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.lookup.LookupRelationship;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.etl.load.LookupData;
import org.openvpms.etl.load.LookupHandler;
import org.openvpms.etl.load.Mapping;
import org.openvpms.etl.load.Mappings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractJUnit4SpringContextTests;

@ContextConfiguration(value={"/applicationContext.xml"})
public class LookupHandlerTestCase
extends AbstractJUnit4SpringContextTests {
    @Autowired
    @Qualifier(value="archetypeService")
    private IArchetypeService service;
    @Autowired
    private LookupService lookups;

    @Test
    public void testCodeGeneration() {
        Mappings mappings = new Mappings();
        Mapping breedMap = this.createMapping("BREED", "<party.patientpet>breed");
        Mapping speciesMap = this.createMapping("SPECIES", "<party.patientpet>species");
        mappings.addMapping(breedMap);
        mappings.addMapping(speciesMap);
        TestLookupHandler handler = new TestLookupHandler(mappings);
        Assert.assertEquals((Object)"KELPIE", (Object)handler.getCode("Kelpie"));
        Assert.assertEquals((Object)"SMALL_DOG", (Object)handler.getCode("Small Dog"));
        Assert.assertEquals((Object)"WIERD_BREED_", (Object)handler.getCode("Wierd breed?"));
    }

    @Test
    public void testLookupGeneration() {
        Mappings mappings = new Mappings();
        Mapping breedMap = this.createMapping("BREED", "<party.patientpet>breed");
        Mapping speciesMap = this.createMapping("SPECIES", "<party.patientpet>species");
        mappings.addMapping(breedMap);
        mappings.addMapping(speciesMap);
        TestLookupHandler handler = new TestLookupHandler(mappings);
        ArchetypeDescriptor archetype = this.service.getArchetypeDescriptor("party.patientpet");
        Assert.assertNotNull((Object)archetype);
        NodeDescriptor breedDesc = archetype.getNodeDescriptor("breed");
        Assert.assertNotNull((Object)breedDesc);
        NodeDescriptor speciesDesc = archetype.getNodeDescriptor("species");
        Assert.assertNotNull((Object)speciesDesc);
        String breedCode = "KELPIE" + System.currentTimeMillis();
        String speciesCode = "CANINE" + System.currentTimeMillis();
        LookupData breed = new LookupData(null, breedCode, "Kelpie");
        LookupData species = new LookupData(null, speciesCode, "Canine");
        HashMap<NodeDescriptor, LookupData> lookups = new HashMap<NodeDescriptor, LookupData>();
        lookups.put(breedDesc, breed);
        lookups.put(speciesDesc, species);
        handler.add(lookups);
        handler.commit();
        List<IMObject> objects = handler.getObjects();
        Assert.assertEquals((long)3L, (long)objects.size());
        Lookup speciesLookup = this.getLookup(objects, "lookup.species");
        Lookup breedLookup = this.getLookup(objects, "lookup.breed");
        LookupRelationship relationship = this.getRelationship(objects, "lookupRelationship.speciesBreed");
        Assert.assertEquals((Object)breedCode, (Object)breedLookup.getCode());
        Assert.assertEquals((Object)speciesCode, (Object)speciesLookup.getCode());
        Assert.assertEquals((Object)speciesLookup.getObjectReference(), (Object)relationship.getSource());
        Assert.assertEquals((Object)breedLookup.getObjectReference(), (Object)relationship.getTarget());
    }

    private Lookup getLookup(List<IMObject> objects, String shortName) {
        return (Lookup)this.getObject(objects, shortName);
    }

    private LookupRelationship getRelationship(List<IMObject> objects, String shortName) {
        return (LookupRelationship)this.getObject(objects, shortName);
    }

    private IMObject getObject(List<IMObject> objects, String shortName) {
        for (IMObject object : objects) {
            if (!TypeHelper.isA((IMObject)object, (String)shortName)) continue;
            return object;
        }
        Assert.fail((String)("No object of type " + shortName));
        return null;
    }

    private Mapping createMapping(String source, String target) {
        Mapping mapping = new Mapping();
        mapping.setSource(source);
        mapping.setTarget(target);
        return mapping;
    }

    class TestLookupHandler
    extends LookupHandler {
        private final List<IMObject> objects;

        TestLookupHandler(Mappings mappings) {
            super(mappings, LookupHandlerTestCase.this.service, LookupHandlerTestCase.this.lookups);
            this.objects = new ArrayList<IMObject>();
        }

        public List<IMObject> getObjects() {
            return this.objects;
        }

        protected void save(Collection<IMObject> objects) {
            this.objects.addAll(objects);
        }

        protected boolean exists(String archetype, String code) {
            return false;
        }

        protected boolean exists(String archetype, Lookup source, Lookup target) {
            return false;
        }
    }
}

