/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2021 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.etl.load;


/**
 * Lookup helper methods.
 *
 * @author Tim Anderson
 */
public class LookupHelper {

    /**
     * Default constructor.
     */
    private LookupHelper() {
        // no-op
    }

    /**
     * Generates a code for a lookup name.
     * This capitalises the lookup name, and replaces all non-alphanumeric
     * characters with underscores.
     *
     * @param name the lookup name
     * @return the lookup code
     */
    public static String getCode(String name) {
        String result = null;
        if (name != null) {
            result = name.toUpperCase();
            result = result.replaceAll("[^A-Z0-9]+", "_");
        }
        return result;
    }

}
