/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.extract;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.common.IMObjectRelationship;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import picocli.CommandLine;

public class ArchetypeDataExtracter {
    private final IArchetypeService service;
    private final boolean activeOnly;
    private final boolean related;
    private final XMLStreamWriter writer;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private final Set<Reference> pending = new LinkedHashSet<Reference>();
    private final Set<Reference> processed = new HashSet<Reference>();
    private final Set<String> dependencies = new HashSet<String>();
    private static final String ARCHETYPE = "archetype";

    public ArchetypeDataExtracter(IArchetypeService service, boolean activeOnly, boolean related, OutputStream out) throws XMLStreamException {
        this.service = service;
        this.activeOnly = activeOnly;
        this.related = related;
        this.writer = new Writer(XMLOutputFactory.newInstance().createXMLStreamWriter(out, "UTF-8"));
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeStartElement(ARCHETYPE);
    }

    public void extract(String[] archetypes, long id, String name) throws XMLStreamException {
        String[] shortNames;
        for (String shortName : shortNames = DescriptorHelper.getShortNames((String[])archetypes, (boolean)true, (ArchetypeService)this.service)) {
            this.extract(shortName, id, name, shortNames);
            this.dependencies.remove(shortName);
        }
    }

    public void close() throws XMLStreamException {
        if (!this.dependencies.isEmpty()) {
            this.writer.writeCharacters("\n");
            ArrayList<String> list = new ArrayList<String>(this.dependencies);
            Collections.sort(list);
            this.writer.writeComment("\nThe following archetypes were referenced but not output:\n" + StringUtils.join(list, (String)"\n") + "\n");
        }
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.close();
    }

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine((Object)new Main());
        int result = commandLine.execute(args);
        System.exit(result);
    }

    private void extract(String archetype, long id, String name, String[] include) throws XMLStreamException {
        ArchetypeQuery query = new ArchetypeQuery(archetype, false, this.activeOnly);
        if (id > 0L) {
            query.add((IConstraint)Constraints.eq((String)"id", (Object)id));
        }
        if (name != null) {
            query.add((IConstraint)Constraints.eq((String)"name", (Object)name));
        }
        query.add((IConstraint)Constraints.sort((String)"id"));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            this.extract((IMObject)iterator.next(), include);
        }
        while (!this.pending.isEmpty()) {
            IMObject child;
            Reference next = this.pending.iterator().next();
            this.pending.remove(next);
            if (this.processed.contains(next) || (child = this.service.get(next)) == null) continue;
            this.extract(child, include);
        }
    }

    private void extract(IMObject object, String[] include) throws XMLStreamException {
        IMObjectReference reference = object.getObjectReference();
        if (this.processed.add((Reference)reference)) {
            this.write(object, null, include);
            this.writer.writeCharacters("\n");
        }
    }

    private List<IMObject> getCollection(IMObjectBean bean, String node) {
        IMObjectReference reference = bean.getReference();
        ArrayList<IMObject> result = new ArrayList<IMObject>();
        List values = bean.getValues(node, IMObject.class);
        for (IMObject value : values) {
            if (value instanceof IMObjectRelationship) {
                if (Objects.equals(reference, ((IMObjectRelationship)value).getTarget())) continue;
                result.add(value);
                continue;
            }
            result.add(value);
        }
        return result;
    }

    private void writeCollectionReference(IMObject object, String collection, String[] include) throws XMLStreamException {
        this.writer.writeEmptyElement("data");
        this.writer.writeAttribute("collection", collection);
        this.writer.writeAttribute(ARCHETYPE, object.getArchetypeId().getShortName());
        this.writer.writeAttribute("childId", this.getReference(object.getArchetypeId(), object.getId()));
        this.queue(object.getObjectReference(), include);
    }

    private void queue(IMObjectReference reference, String[] include) {
        if (!this.related && !TypeHelper.isA((Reference)reference, (String[])include)) {
            this.dependencies.add(reference.getArchetypeId().getShortName());
        } else if (!this.processed.contains(reference)) {
            this.pending.add((Reference)reference);
        }
    }

    private void write(IMObject object, String collection, String[] include) throws XMLStreamException {
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)object, this.service);
        ArrayList<NodeDescriptor> nodes = new ArrayList<NodeDescriptor>();
        LinkedHashMap<NodeDescriptor, List<IMObject>> collectionNodes = new LinkedHashMap<NodeDescriptor, List<IMObject>>();
        ArchetypeDescriptor archetype = bean.getArchetype();
        for (NodeDescriptor nodeDescriptor : archetype.getAllNodeDescriptors()) {
            if (nodeDescriptor.isDerived()) continue;
            if (nodeDescriptor.isCollection()) {
                List<IMObject> objects = this.getCollection(bean, nodeDescriptor.getName());
                if (objects.isEmpty()) continue;
                collectionNodes.put(nodeDescriptor, objects);
                continue;
            }
            nodes.add(nodeDescriptor);
        }
        if (!collectionNodes.isEmpty()) {
            this.writer.writeStartElement("data");
        } else {
            this.writer.writeEmptyElement("data");
        }
        if (collection != null) {
            this.writer.writeAttribute("collection", collection);
        }
        this.writer.writeAttribute(ARCHETYPE, object.getArchetypeId().getShortName());
        for (NodeDescriptor nodeDescriptor : nodes) {
            String name = nodeDescriptor.getName();
            String value = null;
            if (nodeDescriptor.isObjectReference()) {
                IMObjectReference child = bean.getReference(name);
                if (child != null) {
                    this.queue(child, include);
                    value = this.getReference(child.getArchetypeId(), child.getId());
                }
            } else if ("id".equals(name)) {
                if (collection == null) {
                    value = this.getId(object.getArchetypeId(), object.getId());
                }
            } else if (nodeDescriptor.isDate()) {
                Date date = bean.getDate(name);
                if (date != null) {
                    value = this.dateFormat.format(date);
                }
            } else {
                value = bean.getString(name);
            }
            if (value != null) {
                this.writer.writeAttribute(name, value);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)nodeDescriptor.getDefaultValue())) continue;
            this.writer.writeAttribute(name, "");
        }
        for (Map.Entry entry : collectionNodes.entrySet()) {
            NodeDescriptor node = (NodeDescriptor)entry.getKey();
            List objects = (List)entry.getValue();
            String name = node.getName();
            for (IMObject child : objects) {
                if (node.isParentChild()) {
                    this.write(child, name, include);
                    continue;
                }
                this.writeCollectionReference(child, name, include);
            }
        }
        if (!collectionNodes.isEmpty()) {
            this.writer.writeEndElement();
        }
    }

    private String getReference(ArchetypeId archetypeId, long id) {
        return "id:" + this.getId(archetypeId, id);
    }

    private String getId(ArchetypeId archetypeId, long id) {
        return archetypeId.getShortName() + "-" + id;
    }

    @CommandLine.Command(name="dataextract", mixinStandardHelpOptions=true)
    private static class Main
    implements Callable<Integer> {
        @CommandLine.Option(names={"--context", "-c"}, description={"Application context path."}, defaultValue="applicationContext.xml")
        private String contextPath;
        @CommandLine.Option(names={"--archetypes", "-a"}, description={"Archetype(s). May contain wildcards."}, required=true, split=",", paramLabel="archetype")
        private String[] archetypes;
        @CommandLine.Option(names={"--id", "-i"}, description={"Object identifier."})
        private long id;
        @CommandLine.Option(names={"--name", "-n"}, description={"Match object name. May contain wildcards."})
        private String name;
        @CommandLine.Option(names={"--file", "-f"}, description={"Output file name."})
        private String file;
        @CommandLine.Option(names={"--related", "-r"}, description={"Extract related objects."})
        private boolean related;
        @CommandLine.Option(names={"--inactive"}, description={"Include inactive objects of the specified archetypes. Referenced objects may be inactive."})
        private boolean inactive;

        private Main() {
        }

        @Override
        public Integer call() throws Exception {
            OutputStream out;
            Object context = !new File(this.contextPath).exists() ? new ClassPathXmlApplicationContext(this.contextPath) : new FileSystemXmlApplicationContext(this.contextPath);
            if (this.file != null) {
                FileOutputStream fileOutput = new FileOutputStream(this.file);
                out = fileOutput;
            } else {
                out = System.out;
            }
            IArchetypeService service = (IArchetypeService)context.getBean("archetypeService");
            ArchetypeDataExtracter extract = new ArchetypeDataExtracter(service, !this.inactive, this.related, out);
            extract.extract(this.archetypes, this.id, this.name);
            extract.close();
            return 0;
        }
    }

    private static class Writer
    implements XMLStreamWriter {
        private final XMLStreamWriter writer;
        private int depth = 0;

        public Writer(XMLStreamWriter writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws XMLStreamException {
            this.writer.close();
        }

        @Override
        public void flush() throws XMLStreamException {
            this.writer.flush();
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.writer.getNamespaceContext();
        }

        @Override
        public String getPrefix(String uri) throws XMLStreamException {
            return this.writer.getPrefix(uri);
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            return this.writer.getProperty(name);
        }

        @Override
        public void setDefaultNamespace(String uri) throws XMLStreamException {
            this.writer.setDefaultNamespace(uri);
        }

        @Override
        public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
            this.writer.setNamespaceContext(context);
        }

        @Override
        public void setPrefix(String prefix, String uri) throws XMLStreamException {
            this.writer.setPrefix(prefix, uri);
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.writer.writeAttribute(localName, value);
        }

        @Override
        public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
            this.writer.writeAttribute(namespaceURI, localName, value);
        }

        @Override
        public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
            this.writer.writeAttribute(prefix, namespaceURI, localName, value);
        }

        @Override
        public void writeCData(String data) throws XMLStreamException {
            this.writer.writeCData(data);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.writer.writeCharacters(text, start, len);
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            this.writer.writeCharacters(text);
        }

        @Override
        public void writeComment(String data) throws XMLStreamException {
            this.writer.writeComment(data);
        }

        @Override
        public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
            this.writer.writeDefaultNamespace(namespaceURI);
        }

        @Override
        public void writeDTD(String dtd) throws XMLStreamException {
            this.writer.writeDTD(dtd);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.newElement();
            this.writer.writeEmptyElement(localName);
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.newElement();
            this.writer.writeEmptyElement(namespaceURI, localName);
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.newElement();
            this.writer.writeEmptyElement(prefix, namespaceURI, localName);
        }

        @Override
        public void writeEndDocument() throws XMLStreamException {
            this.writer.writeEndDocument();
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.startElement();
            this.writer.writeStartElement(localName);
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.startElement();
            this.writer.writeStartElement(namespaceURI, localName);
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.startElement();
            this.writer.writeStartElement(prefix, namespaceURI, localName);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.endElement();
            this.writer.writeEndElement();
        }

        @Override
        public void writeEntityRef(String name) throws XMLStreamException {
            this.writer.writeEntityRef(name);
        }

        @Override
        public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
            this.writer.writeNamespace(prefix, namespaceURI);
        }

        @Override
        public void writeProcessingInstruction(String target) throws XMLStreamException {
            this.writer.writeProcessingInstruction(target);
        }

        @Override
        public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
            this.writer.writeProcessingInstruction(target, data);
        }

        @Override
        public void writeStartDocument() throws XMLStreamException {
            this.writer.writeStartDocument();
            this.writer.writeCharacters("\n");
        }

        @Override
        public void writeStartDocument(String version) throws XMLStreamException {
            this.writer.writeStartDocument(version);
            this.writer.writeCharacters("\n");
        }

        @Override
        public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            this.writer.writeStartDocument(encoding, version);
            this.writer.writeCharacters("\n");
        }

        private void startElement() throws XMLStreamException {
            this.newElement();
            ++this.depth;
        }

        private void endElement() throws XMLStreamException {
            this.writer.writeCharacters("\n");
            --this.depth;
            this.indent();
        }

        private void newElement() throws XMLStreamException {
            if (this.depth > 0) {
                this.writer.writeCharacters("\n");
            }
            this.indent();
        }

        private void indent() throws XMLStreamException {
            for (int i = 0; i < this.depth; ++i) {
                this.writer.writeCharacters("  ");
            }
        }
    }
}

