/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.order;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.AbstractUBLMapper;
import org.openvpms.esci.adapter.map.order.OrderResponseMapper;
import org.openvpms.esci.adapter.map.order.UBLOrderResponseSimple;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.order.OrderResponseSimpleType;

public class OrderResponseMapperImpl
extends AbstractUBLMapper
implements OrderResponseMapper {
    public OrderResponseMapperImpl(IArchetypeService service) {
        super(service);
    }

    @Override
    public FinancialAct map(OrderResponseSimpleType response, Party supplier, Party stockLocation, String accountId) {
        Message message;
        String status;
        UBLOrderResponseSimple wrapper = new UBLOrderResponseSimple(response, this.getService());
        this.checkUBLVersion(wrapper);
        wrapper.checkSupplier(supplier, accountId);
        wrapper.checkStockLocation(stockLocation, accountId);
        FinancialAct order = wrapper.getOrder();
        this.checkOrder(order, supplier, stockLocation, wrapper);
        this.checkDuplicateResponse(order, response);
        if (wrapper.isAccepted()) {
            status = "ACCEPTED";
            message = ESCIAdapterMessages.orderAccepted();
        } else {
            status = "REJECTED";
            String note = wrapper.getRejectionNote();
            message = note != null ? ESCIAdapterMessages.orderRejected(note) : ESCIAdapterMessages.orderRejectedNoReason();
        }
        IMObjectBean bean = this.getService().getBean((IMObject)order);
        bean.setValue("status", (Object)status);
        bean.setValue("supplierResponse", (Object)message.getMessage());
        return order;
    }

    private void checkDuplicateResponse(FinancialAct order, OrderResponseSimpleType response) {
        if (order.getStatus().equals("ACCEPTED") || order.getStatus().equals("REJECTED")) {
            throw new ESCIAdapterException(ESCIAdapterMessages.duplicateOrderResponse(order.getId(), response.getID().getValue()));
        }
    }
}

