/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.order;

import java.math.BigDecimal;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.math.Currencies;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.UBLHelper;
import org.openvpms.esci.adapter.map.order.OrderMapper;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.common.aggregate.AddressLineType;
import org.openvpms.esci.ubl.common.aggregate.AddressType;
import org.openvpms.esci.ubl.common.aggregate.ContactType;
import org.openvpms.esci.ubl.common.aggregate.CustomerPartyType;
import org.openvpms.esci.ubl.common.aggregate.ItemIdentificationType;
import org.openvpms.esci.ubl.common.aggregate.ItemType;
import org.openvpms.esci.ubl.common.aggregate.LineItemType;
import org.openvpms.esci.ubl.common.aggregate.MonetaryTotalType;
import org.openvpms.esci.ubl.common.aggregate.OrderLineType;
import org.openvpms.esci.ubl.common.aggregate.PartyNameType;
import org.openvpms.esci.ubl.common.aggregate.PartyType;
import org.openvpms.esci.ubl.common.aggregate.PriceType;
import org.openvpms.esci.ubl.common.aggregate.SupplierPartyType;
import org.openvpms.esci.ubl.common.aggregate.TaxTotalType;
import org.openvpms.esci.ubl.common.basic.BaseQuantityType;
import org.openvpms.esci.ubl.common.basic.CityNameType;
import org.openvpms.esci.ubl.common.basic.CopyIndicatorType;
import org.openvpms.esci.ubl.common.basic.CountrySubentityType;
import org.openvpms.esci.ubl.common.basic.CustomerAssignedAccountIDType;
import org.openvpms.esci.ubl.common.basic.DescriptionType;
import org.openvpms.esci.ubl.common.basic.ElectronicMailType;
import org.openvpms.esci.ubl.common.basic.IDType;
import org.openvpms.esci.ubl.common.basic.IssueDateType;
import org.openvpms.esci.ubl.common.basic.IssueTimeType;
import org.openvpms.esci.ubl.common.basic.LineExtensionAmountType;
import org.openvpms.esci.ubl.common.basic.LineType;
import org.openvpms.esci.ubl.common.basic.NameType;
import org.openvpms.esci.ubl.common.basic.PackQuantityType;
import org.openvpms.esci.ubl.common.basic.PackSizeNumericType;
import org.openvpms.esci.ubl.common.basic.PayableAmountType;
import org.openvpms.esci.ubl.common.basic.PostalZoneType;
import org.openvpms.esci.ubl.common.basic.PriceAmountType;
import org.openvpms.esci.ubl.common.basic.QuantityType;
import org.openvpms.esci.ubl.common.basic.SupplierAssignedAccountIDType;
import org.openvpms.esci.ubl.common.basic.TaxAmountType;
import org.openvpms.esci.ubl.common.basic.TelefaxType;
import org.openvpms.esci.ubl.common.basic.TelephoneType;
import org.openvpms.esci.ubl.common.basic.TotalTaxAmountType;
import org.openvpms.esci.ubl.common.basic.UBLVersionIDType;
import org.openvpms.esci.ubl.order.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderMapperImpl
implements OrderMapper {
    private final DatatypeFactory datatypeFactory;
    private final LookupService lookupService;
    private final PracticeRules practiceRules;
    private final LocationRules locationRules;
    private final PartyRules partyRules;
    private final SupplierRules supplierRules;
    private final Currencies currencies;
    private final ArchetypeService service;
    private final Contacts contacts;
    private static final Logger log = LoggerFactory.getLogger(OrderMapperImpl.class);
    private static final String DEFAULT_PACKAGE_UNITS = "EA";

    public OrderMapperImpl(PracticeRules practiceRules, LocationRules locationRules, PartyRules partyRules, SupplierRules supplierRules, LookupService lookupService, Currencies currencies, ArchetypeService service) {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException exception) {
            throw new IllegalStateException(exception);
        }
        this.practiceRules = practiceRules;
        this.locationRules = locationRules;
        this.partyRules = partyRules;
        this.supplierRules = supplierRules;
        this.lookupService = lookupService;
        this.currencies = currencies;
        this.service = service;
        this.contacts = new Contacts(service);
    }

    @Override
    public Order map(FinancialAct order) {
        Order result = new Order();
        Currency currency = this.getCurrency();
        UBLVersionIDType version = UBLHelper.initID(new UBLVersionIDType(), "2.0");
        IDType id = UBLHelper.createID(order.getId());
        CopyIndicatorType copyIndicator = this.getCopyIndicatorType(false);
        GregorianCalendar startTime = new GregorianCalendar();
        startTime.setTime(order.getActivityStartTime());
        IssueDateType issueDate = UBLHelper.createIssueDate(startTime, this.datatypeFactory);
        IssueTimeType issueTime = UBLHelper.createIssueTime(startTime, this.datatypeFactory);
        IMObjectBean bean = this.service.getBean((IMObject)order);
        Entity author = (Entity)bean.getObject("createdBy", Entity.class);
        Party stockLocation = (Party)bean.getTarget("stockLocation", Party.class);
        Party location = this.getLocation(stockLocation);
        Party supplier = (Party)bean.getTarget("supplier", Party.class);
        EntityRelationship supplierStockLocation = this.supplierRules.getSupplierStockLocation(supplier, stockLocation);
        if (supplierStockLocation == null) {
            throw new ESCIAdapterException(ESCIAdapterMessages.ESCINotConfigured(supplier, stockLocation));
        }
        String contactName = author != null ? author.getName() : null;
        CustomerPartyType customerParty = this.getCustomer(contactName, location, stockLocation, supplierStockLocation);
        SupplierPartyType supplierParty = this.getSupplier(supplier);
        TaxTotalType taxTotal = this.getTaxTotal(order, currency);
        MonetaryTotalType total = this.getMonetaryTotal(order, currency);
        result.setUBLVersionID(version);
        result.setID(id);
        result.setCopyIndicator(copyIndicator);
        result.setIssueDate(issueDate);
        result.setIssueTime(issueTime);
        result.setBuyerCustomerParty(customerParty);
        result.setSellerSupplierParty(supplierParty);
        result.getTaxTotal().add(taxTotal);
        result.setAnticipatedMonetaryTotal(total);
        for (Act item : bean.getTargets("items", Act.class)) {
            OrderLineType line = this.getOrderLine(item, supplier, currency);
            result.getOrderLine().add(line);
        }
        return result;
    }

    private OrderLineType getOrderLine(Act act, Party supplier, Currency currency) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Product product = (Product)bean.getTarget("product", Product.class);
        OrderLineType orderLine = new OrderLineType();
        LineItemType lineItem = new LineItemType();
        String packageUnits = bean.getString("packageUnits");
        String unitCode = this.getUnitCode(packageUnits);
        ItemType item = this.getItem(bean, supplier, product, unitCode);
        lineItem.setItem(item);
        orderLine.setLineItem(lineItem);
        IDType id = UBLHelper.createID(act.getId());
        QuantityType quantity = UBLHelper.initQuantity(new QuantityType(), bean.getBigDecimal("quantity"), unitCode);
        LineExtensionAmountType lineAmount = UBLHelper.initAmount(new LineExtensionAmountType(), bean.getBigDecimal("total"), currency);
        TotalTaxAmountType taxAmount = UBLHelper.initAmount(new TotalTaxAmountType(), bean.getBigDecimal("tax"), currency);
        PriceType price = this.getPrice(bean.getBigDecimal("unitPrice", BigDecimal.ZERO), unitCode, currency);
        lineItem.setID(id);
        lineItem.setQuantity(quantity);
        lineItem.setLineExtensionAmount(lineAmount);
        lineItem.setTotalTaxAmount(taxAmount);
        lineItem.setPrice(price);
        return orderLine;
    }

    private ItemType getItem(IMObjectBean bean, Party supplier, Product product, String packageUnits) {
        ItemType result = new ItemType();
        ItemIdentificationType buyersId = this.getItemIdentification(product.getId());
        String reorderCode = bean.getString("reorderCode");
        String reorderDescription = bean.getString("reorderDescription");
        if (StringUtils.isEmpty((CharSequence)reorderCode)) {
            throw new ESCIAdapterException(ESCIAdapterMessages.noSupplierOrderCode(supplier, product));
        }
        ItemIdentificationType sellersId = this.getItemIdentification(reorderCode);
        result.setSellersItemIdentification(sellersId);
        if (!StringUtils.isEmpty((CharSequence)reorderDescription)) {
            DescriptionType description = UBLHelper.initText(new DescriptionType(), reorderDescription);
            result.getDescription().add(description);
        }
        NameType name = UBLHelper.initName(new NameType(), product.getName());
        result.setBuyersItemIdentification(buyersId);
        result.setName(name);
        BigDecimal packageSize = bean.getBigDecimal("packageSize");
        if (packageSize != null && packageUnits != null) {
            PackQuantityType quantity = UBLHelper.initQuantity(new PackQuantityType(), BigDecimal.ONE, packageUnits);
            PackSizeNumericType size = UBLHelper.createPackSizeNumeric(packageSize);
            result.setPackQuantity(quantity);
            result.setPackSizeNumeric(size);
        }
        return result;
    }

    private PriceType getPrice(BigDecimal price, String unitCode, Currency currency) {
        PriceType result = new PriceType();
        PriceAmountType priceAmount = UBLHelper.initAmount(new PriceAmountType(), price, currency);
        result.setPriceAmount(priceAmount);
        result.setBaseQuantity(UBLHelper.initQuantity(new BaseQuantityType(), BigDecimal.ONE, unitCode));
        return result;
    }

    private TaxTotalType getTaxTotal(FinancialAct order, Currency currency) {
        TaxTotalType result = new TaxTotalType();
        result.setTaxAmount(UBLHelper.initAmount(new TaxAmountType(), order.getTaxAmount(), currency));
        return result;
    }

    private MonetaryTotalType getMonetaryTotal(FinancialAct order, Currency currency) {
        BigDecimal payableAmount = order.getTotal();
        BigDecimal lineExtensionAmount = payableAmount.subtract(order.getTaxAmount());
        MonetaryTotalType result = new MonetaryTotalType();
        result.setLineExtensionAmount(UBLHelper.initAmount(new LineExtensionAmountType(), lineExtensionAmount, currency));
        result.setPayableAmount(UBLHelper.initAmount(new PayableAmountType(), payableAmount, currency));
        return result;
    }

    private String getUnitCode(String packageUnits) {
        String result = null;
        if (!StringUtils.isEmpty((CharSequence)"packageUnits")) {
            IMObjectBean lookupBean;
            String unitCode;
            Lookup lookup = this.lookupService.getLookup("lookup.uom", packageUnits);
            if (lookup != null && !StringUtils.isEmpty((CharSequence)(unitCode = (lookupBean = this.service.getBean((IMObject)lookup)).getString("unitCode")))) {
                result = unitCode;
            }
            if (result == null) {
                log.warn("No unit code for package units={}. Defaulting to {}", (Object)packageUnits, (Object)DEFAULT_PACKAGE_UNITS);
            }
        }
        if (result == null) {
            result = DEFAULT_PACKAGE_UNITS;
        }
        return result;
    }

    private Party getLocation(Party stockLocation) {
        IMObjectBean bean = this.service.getBean((IMObject)stockLocation);
        Party result = (Party)bean.getSource("locations", Party.class);
        if (result == null) {
            throw new ESCIAdapterException(ESCIAdapterMessages.noPracticeLocationForStockLocation(stockLocation));
        }
        return result;
    }

    private CustomerPartyType getCustomer(String contactName, Party location, Party stockLocation, EntityRelationship supplierStockLocation) {
        Party customer;
        CustomerPartyType result = new CustomerPartyType();
        Party practice = this.locationRules.getPractice(location);
        if (practice == null) {
            throw new IllegalStateException("No practice for location: " + location.getId());
        }
        Contact locationContact = this.partyRules.getContact(location, "contact.location", "BILLING");
        if (locationContact == null) {
            locationContact = this.partyRules.getContact(practice, "contact.location", "BILLING");
            if (locationContact == null) {
                throw new IllegalStateException("No contact.location for location: " + location.getId());
            }
            customer = practice;
        } else {
            customer = location;
        }
        Contact phoneContact = this.partyRules.getContact(customer, "contact.phoneNumber", false, "FAX", new String[]{"BILLING"});
        Contact faxContact = this.partyRules.getContact(customer, "contact.phoneNumber", true, null, new String[]{"FAX", "BILLING"});
        if (faxContact == null) {
            faxContact = this.partyRules.getContact(customer, "contact.phoneNumber", true, null, new String[]{"FAX"});
        }
        Contact emailContact = this.partyRules.getContact(customer, "contact.email", "BILLING");
        CustomerAssignedAccountIDType customerId = UBLHelper.initID(new CustomerAssignedAccountIDType(), stockLocation.getId());
        PartyType party = this.getParty(customer, locationContact);
        party.setContact(this.getContact(contactName, phoneContact, faxContact, emailContact));
        result.setCustomerAssignedAccountID(customerId);
        IMObjectBean bean = this.service.getBean((IMObject)supplierStockLocation);
        String accountId = bean.getString("accountId");
        if (!StringUtils.isEmpty((CharSequence)accountId)) {
            SupplierAssignedAccountIDType supplierId = UBLHelper.initID(new SupplierAssignedAccountIDType(), accountId);
            result.setSupplierAssignedAccountID(supplierId);
        }
        result.setParty(party);
        return result;
    }

    private SupplierPartyType getSupplier(Party supplier) {
        SupplierPartyType result = new SupplierPartyType();
        CustomerAssignedAccountIDType accountId = UBLHelper.initID(new CustomerAssignedAccountIDType(), supplier.getId());
        Contact contact = this.partyRules.getContact(supplier, "contact.location", null);
        result.setCustomerAssignedAccountID(accountId);
        result.setParty(this.getParty(supplier, contact));
        return result;
    }

    private PartyType getParty(Party party, Contact location) {
        PartyType result = new PartyType();
        PartyNameType partyName = new PartyNameType();
        partyName.setName(UBLHelper.createName(party.getName()));
        result.getPartyName().add(partyName);
        if (location != null) {
            result.setPostalAddress(this.getAddress(location));
        }
        return result;
    }

    private ContactType getContact(String name, Contact phone, Contact fax, Contact email) {
        ContactType contact = new ContactType();
        if (!StringUtils.isEmpty((CharSequence)name)) {
            contact.setName(UBLHelper.initName(new NameType(), name));
        }
        contact.setTelephone(this.getPhone(phone));
        contact.setTelefax(this.getFax(fax));
        contact.setElectronicMail(this.getEmail(email));
        return contact;
    }

    private TelephoneType getPhone(Contact contact) {
        String phone = contact != null ? this.contacts.getPhone(contact) : null;
        return phone != null ? UBLHelper.initText(new TelephoneType(), phone) : null;
    }

    private TelefaxType getFax(Contact contact) {
        String fax = contact != null ? this.contacts.getPhone(contact) : null;
        return fax != null ? UBLHelper.initText(new TelefaxType(), fax) : null;
    }

    private ElectronicMailType getEmail(Contact contact) {
        String email = null;
        if (contact != null) {
            IMObjectBean bean = this.service.getBean((IMObject)contact);
            email = StringUtils.trimToNull((String)bean.getString("emailAddress"));
        }
        return email != null ? UBLHelper.initText(new ElectronicMailType(), email) : null;
    }

    private AddressType getAddress(Contact contact) {
        IMObjectBean bean = this.service.getBean((IMObject)contact);
        AddressType result = new AddressType();
        AddressLineType addressLineType = new AddressLineType();
        LineType line = UBLHelper.initText(new LineType(), bean.getString("address"));
        addressLineType.setLine(line);
        String city = this.lookupService.getName((IMObject)contact, "suburb");
        CityNameType cityName = UBLHelper.initName(new CityNameType(), city);
        String state = this.lookupService.getName((IMObject)contact, "state");
        CountrySubentityType stateName = UBLHelper.initText(new CountrySubentityType(), state);
        PostalZoneType postCode = UBLHelper.initText(new PostalZoneType(), bean.getString("postcode"));
        result.getAddressLine().add(addressLineType);
        result.setCityName(cityName);
        result.setCountrySubentity(stateName);
        result.setPostalZone(postCode);
        return result;
    }

    private ItemIdentificationType getItemIdentification(long id) {
        ItemIdentificationType result = new ItemIdentificationType();
        result.setID(UBLHelper.createID(id));
        return result;
    }

    private ItemIdentificationType getItemIdentification(String id) {
        ItemIdentificationType result = new ItemIdentificationType();
        result.setID(UBLHelper.createID(id));
        return result;
    }

    private CopyIndicatorType getCopyIndicatorType(boolean value) {
        CopyIndicatorType result = new CopyIndicatorType();
        result.setValue(value);
        return result;
    }

    private Currency getCurrency() {
        return UBLHelper.getCurrency(this.practiceRules, this.currencies, this.service);
    }
}

