/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.invoice;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

class TaxRates {
    private final ArchetypeService service;
    private final LookupService lookups;
    private final Map<String, BigDecimal> cache = new HashMap<String, BigDecimal>();

    public TaxRates(ArchetypeService service, LookupService lookups) {
        this.service = service;
        this.lookups = lookups;
    }

    public BigDecimal getTaxRate(String scheme, String category) {
        String key = scheme + "-" + category;
        BigDecimal result = this.cache.get(key);
        if (result == null) {
            for (Lookup lookup : this.lookups.getLookups("lookup.taxType")) {
                IMObjectBean bean = this.service.getBean((IMObject)lookup);
                if (!Objects.equals(scheme, bean.getValue("taxScheme")) || !Objects.equals(category, bean.getValue("taxCategory"))) continue;
                result = bean.getBigDecimal("rate");
                this.cache.put(key, result);
                break;
            }
        }
        return result;
    }
}

