/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.invoice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.esci.adapter.map.invoice.Package;

class PackageHelper {
    private final ProductRules rules;
    private final ArchetypeService service;
    private final LookupService lookups;
    private Map<String, String> unitCodes;

    public PackageHelper(ProductRules rules, ArchetypeService service, LookupService lookups) {
        this.rules = rules;
        this.lookups = lookups;
        this.service = service;
    }

    public Package getPackage(FinancialAct orderItem, Product product, Party supplier) {
        List list;
        Package result = null;
        int packageSize = 0;
        String packageUnits = null;
        if (orderItem != null) {
            IMObjectBean bean = this.service.getBean((IMObject)orderItem);
            packageSize = bean.getInt("packageSize");
            packageUnits = bean.getString("packageUnits");
        }
        if (packageSize != 0 && !StringUtils.isEmpty(packageUnits)) {
            result = new Package(packageSize, packageUnits);
        } else if (product != null && (list = this.rules.getProductSuppliers(product, supplier)).size() == 1) {
            ProductSupplier ps = (ProductSupplier)list.get(0);
            result = new Package(ps);
        }
        return result;
    }

    public List<String> getPackageUnits(String unitCode) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.unitCodes == null) {
            this.unitCodes = this.getUnitCodes();
        }
        for (Map.Entry<String, String> entry : this.unitCodes.entrySet()) {
            if (!StringUtils.equals((CharSequence)entry.getValue(), (CharSequence)unitCode)) continue;
            result.add(entry.getKey());
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }

    private Map<String, String> getUnitCodes() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Lookup lookup : this.lookups.getLookups("lookup.uom")) {
            IMObjectBean lookupBean = this.service.getBean((IMObject)lookup);
            String unitCode = lookupBean.getString("unitCode");
            if (unitCode == null) continue;
            result.put(lookup.getCode(), unitCode);
        }
        return result;
    }
}

