/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.invoice;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.math.Currencies;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.AbstractUBLMapper;
import org.openvpms.esci.adapter.map.ErrorContext;
import org.openvpms.esci.adapter.map.UBLHelper;
import org.openvpms.esci.adapter.map.UBLType;
import org.openvpms.esci.adapter.map.invoice.DefaultOrderResolver;
import org.openvpms.esci.adapter.map.invoice.Delivery;
import org.openvpms.esci.adapter.map.invoice.InvoiceLineState;
import org.openvpms.esci.adapter.map.invoice.InvoiceMapper;
import org.openvpms.esci.adapter.map.invoice.InvoiceOrderMatcher;
import org.openvpms.esci.adapter.map.invoice.MappingContext;
import org.openvpms.esci.adapter.map.invoice.OrderResolver;
import org.openvpms.esci.adapter.map.invoice.Package;
import org.openvpms.esci.adapter.map.invoice.PackageHelper;
import org.openvpms.esci.adapter.map.invoice.TaxRates;
import org.openvpms.esci.adapter.map.invoice.UBLAllowanceCharge;
import org.openvpms.esci.adapter.map.invoice.UBLInvoice;
import org.openvpms.esci.adapter.map.invoice.UBLInvoiceLine;
import org.openvpms.esci.adapter.map.invoice.UBLTaxCategory;
import org.openvpms.esci.adapter.map.invoice.UBLTaxSubtotal;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.invoice.InvoiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceMapperImpl
extends AbstractUBLMapper
implements InvoiceMapper {
    private final PracticeRules practiceRules;
    private final SupplierRules supplierRules;
    private final ProductRules productRules;
    private final Currencies currencies;
    private final LookupService lookupService;
    private final PackageHelper packageHelper;
    private static final Logger log = LoggerFactory.getLogger(InvoiceMapperImpl.class);
    private static final String START_TIME = "startTime";

    public InvoiceMapperImpl(PracticeRules practiceRules, SupplierRules supplierRules, ProductRules productRules, Currencies currencies, IArchetypeService service, LookupService lookups) {
        super(service);
        this.practiceRules = practiceRules;
        this.supplierRules = supplierRules;
        this.productRules = productRules;
        this.currencies = currencies;
        this.lookupService = lookups;
        this.packageHelper = new PackageHelper(productRules, (ArchetypeService)service, this.lookupService);
    }

    @Override
    public Delivery map(InvoiceType invoice, Party supplier, Party stockLocation, String accountId) {
        return this.map(invoice, supplier, stockLocation, accountId, new DefaultOrderResolver((ArchetypeService)this.getService()));
    }

    @Override
    public Delivery map(InvoiceType invoice, Party supplier, Party stockLocation, String accountId, OrderResolver orderResolver) {
        Delivery result = new Delivery();
        IArchetypeService service = this.getService();
        Currency practiceCurrency = UBLHelper.getCurrency(this.practiceRules, this.currencies, (ArchetypeService)service);
        TaxRates rates = new TaxRates((ArchetypeService)service, this.lookupService);
        UBLInvoice wrapper = new UBLInvoice(invoice, practiceCurrency.getCode(), service, this.supplierRules);
        String invoiceId = wrapper.getMandatoryID();
        this.checkUBLVersion(wrapper);
        Date issueDatetime = wrapper.getIssueDatetime();
        String notes = wrapper.getNotes();
        wrapper.checkSupplier(supplier, accountId);
        wrapper.checkStockLocation(stockLocation, accountId);
        this.checkDuplicateInvoice(supplier, invoiceId);
        InvoiceOrderMatcher matcher = new InvoiceOrderMatcher(this.getService(), orderResolver);
        MappingContext context = matcher.match(wrapper, supplier, stockLocation);
        result.setOrder(context.getDocumentOrder());
        BigDecimal payableAmount = wrapper.getPayableAmount();
        BigDecimal invoiceLineExtensionAmount = wrapper.getLineExtensionAmount();
        BigDecimal chargeTotal = wrapper.getChargeTotal();
        BigDecimal taxExclusiveAmount = wrapper.getTaxExclusiveAmount();
        BigDecimal taxTotal = wrapper.getTaxAmount();
        IMObjectBean delivery = service.getBean((IMObject)service.create("act.supplierDelivery"));
        delivery.setValue(START_TIME, (Object)issueDatetime);
        delivery.setValue("supplierNotes", (Object)notes);
        delivery.setValue("amount", (Object)payableAmount);
        delivery.setValue("tax", (Object)taxTotal);
        ActIdentity identity = (ActIdentity)service.create("actIdentity.supplierInvoiceESCI", ActIdentity.class);
        identity.setIdentity(invoiceId);
        delivery.addValue("supplierInvoiceId", (IMObject)identity);
        delivery.setTarget("supplier", (IMObject)supplier);
        delivery.setTarget("stockLocation", (IMObject)stockLocation);
        result.setDelivery((FinancialAct)delivery.getObject(FinancialAct.class));
        List<InvoiceLineState> lines = context.getInvoiceLines();
        if (lines.isEmpty()) {
            throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidCardinality("InvoiceLine", "Invoice", invoiceId, "1..*", 0));
        }
        BigDecimal itemTaxExTotal = BigDecimal.ZERO;
        BigDecimal itemTax = BigDecimal.ZERO;
        BigDecimal itemLineExtensionAmount = BigDecimal.ZERO;
        BigDecimal itemCharge = BigDecimal.ZERO;
        for (InvoiceLineState state : lines) {
            UBLInvoiceLine line = state.getLine();
            BigDecimal amount = line.getLineExtensionAmount();
            FinancialAct item = this.mapInvoiceLine(state, issueDatetime, rates, context);
            service.deriveValues((IMObject)item);
            ActRelationship relationship = (ActRelationship)delivery.addTarget("items", (IMObject)item);
            item.addActRelationship(relationship);
            result.addDeliveryItem(item);
            itemLineExtensionAmount = itemLineExtensionAmount.add(amount);
            itemTax = itemTax.add(item.getTaxAmount());
            itemTaxExTotal = itemTaxExTotal.add(item.getTotal().subtract(item.getTaxAmount()));
        }
        for (FinancialAct relatedOrder : context.getOrders()) {
            delivery.addTarget("orders", (IMObject)relatedOrder, "deliveries");
        }
        for (UBLAllowanceCharge allowanceCharge : wrapper.getAllowanceCharges()) {
            FinancialAct item = this.mapCharge(allowanceCharge, issueDatetime, invoiceId, rates);
            service.deriveValues((IMObject)item);
            ActRelationship relationship = (ActRelationship)delivery.addTarget("items", (IMObject)item);
            item.addActRelationship(relationship);
            result.addDeliveryItem(item);
            itemTax = itemTax.add(item.getTaxAmount());
            itemCharge = itemCharge.add(item.getTotal()).subtract(item.getTaxAmount());
        }
        if (chargeTotal.compareTo(itemCharge) != 0) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invoiceInvalidChargeTotal(invoiceId, chargeTotal, itemCharge));
        }
        itemTaxExTotal = itemTaxExTotal.add(itemCharge);
        BigDecimal itemTaxIncTotal = itemTaxExTotal.add(itemTax);
        if (taxTotal.compareTo(itemTax) != 0) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invoiceInvalidTax(invoiceId, taxTotal, itemTax));
        }
        if (itemLineExtensionAmount.compareTo(invoiceLineExtensionAmount) != 0) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invoiceInvalidLineExtensionAmount(invoiceId, invoiceLineExtensionAmount, itemLineExtensionAmount));
        }
        if (itemTaxExTotal.compareTo(taxExclusiveAmount) != 0) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invoiceInvalidTaxExclusiveAmount(invoiceId, taxExclusiveAmount, itemTaxExTotal));
        }
        if (payableAmount.compareTo(itemTaxIncTotal) != 0) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invoiceInvalidPayableAmount(invoiceId, payableAmount, itemTaxIncTotal));
        }
        return result;
    }

    protected void checkDuplicateInvoice(Party supplier, String invoiceId) {
        ArchetypeQuery query = new ArchetypeQuery("act.supplierDelivery");
        query.getArchetypeConstraint().setAlias("delivery");
        query.add((IConstraint)Constraints.join((String)"supplier").add((IConstraint)Constraints.eq((String)"entity", (Object)supplier)));
        query.add((IConstraint)Constraints.join((String)"supplierInvoiceId").add((IConstraint)Constraints.eq((String)"identity", (Object)invoiceId)));
        query.setMaxResults(1);
        IArchetypeService service = this.getService();
        IMObjectQueryIterator iter = new IMObjectQueryIterator(service, (IArchetypeQuery)query);
        if (iter.hasNext()) {
            FinancialAct delivery = (FinancialAct)iter.next();
            throw new ESCIAdapterException(ESCIAdapterMessages.duplicateInvoice(invoiceId, delivery.getId()));
        }
    }

    protected void checkTax(UBLInvoiceLine line, TaxRates rates) {
        BigDecimal expectedTaxAmount = line.getTaxAmount();
        UBLTaxSubtotal subtotal = line.getTaxSubtotal();
        this.checkTax(subtotal, expectedTaxAmount, line.getLineExtensionAmount(), rates, line);
    }

    protected void checkTax(UBLTaxSubtotal subtotal, BigDecimal expectedTaxAmount, BigDecimal amount, TaxRates rates, UBLType parent) {
        if (subtotal != null) {
            BigDecimal calc;
            BigDecimal taxAmount = subtotal.getTaxAmount();
            if (expectedTaxAmount.compareTo(taxAmount) != 0) {
                ErrorContext context = new ErrorContext(subtotal, "TaxAmount");
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue(context.getPath(), context.getType(), context.getID(), expectedTaxAmount.toString(), taxAmount.toString()));
            }
            UBLTaxCategory category = subtotal.getTaxCategory();
            BigDecimal rate = this.checkTaxCategory(category, rates);
            BigDecimal divisor = BigDecimal.valueOf(100L);
            if (taxAmount.compareTo(BigDecimal.ZERO) != 0 && (calc = MathRules.divide((BigDecimal)amount.multiply(rate), (BigDecimal)divisor, (int)2)).compareTo(expectedTaxAmount) != 0) {
                ErrorContext context = new ErrorContext(subtotal, "TaxTotal/TaxAmount");
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue(context.getPath(), context.getType(), context.getID(), calc.toString(), expectedTaxAmount.toString()));
            }
        } else if (expectedTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
            ErrorContext context = new ErrorContext(parent, "TaxTotal");
            throw new ESCIAdapterException(ESCIAdapterMessages.ublElementRequired(context.getPath(), context.getType(), context.getID()));
        }
    }

    protected BigDecimal checkTaxCategory(UBLTaxCategory category, TaxRates rates) {
        String taxCategory = category.getMandatoryID();
        BigDecimal rate = category.getTaxRate();
        String taxScheme = category.getTaxTypeCode();
        BigDecimal expectedRate = rates.getTaxRate(taxScheme, taxCategory);
        if (expectedRate == null) {
            ErrorContext context = new ErrorContext(category);
            throw new ESCIAdapterException(ESCIAdapterMessages.invalidTaxSchemeAndCategory(context.getPath(), context.getType(), context.getID(), taxScheme, taxCategory));
        }
        if (expectedRate.compareTo(rate) != 0) {
            ErrorContext context = new ErrorContext(category, "Percent");
            throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue(context.getPath(), context.getType(), context.getID(), expectedRate.toString(), rate.toString()));
        }
        return rate;
    }

    protected FinancialAct mapOrderItem(InvoiceLineState line) {
        IMObjectBean itemBean;
        Reference orderedProduct;
        FinancialAct item = line.getOrderItem();
        Product invoiced = line.getProduct();
        if (item != null && invoiced != null && !Objects.equals(orderedProduct = (itemBean = this.getService().getBean((IMObject)item)).getTargetRef("product"), invoiced.getObjectReference())) {
            log.warn("Invoiced product doesn't refer to that ordered");
            item = null;
        }
        return item;
    }

    protected FinancialAct mapInvoiceLine(InvoiceLineState lineState, Date startTime, TaxRates rates, MappingContext context) {
        IArchetypeService service = this.getService();
        IMObjectBean deliveryItem = service.getBean((IMObject)service.create("act.supplierDeliveryItem"));
        UBLInvoiceLine line = lineState.getLine();
        BigDecimal quantity = line.getInvoicedQuantity();
        String invoicedUnitCode = line.getInvoicedQuantityUnitCode();
        this.checkPackQuantity(line, invoicedUnitCode);
        this.checkBaseQuantity(line, invoicedUnitCode);
        Party supplier = context.getSupplier();
        Product product = lineState.getProduct();
        BigDecimal lineExtensionAmount = line.getLineExtensionAmount();
        String reorderCode = line.getSellersItemID();
        String reorderDescription = line.getItemName();
        BigDecimal tax = line.getTaxAmount();
        FinancialAct orderItem = this.mapOrderItem(lineState);
        Package pkg = this.packageHelper.getPackage(orderItem, product, supplier);
        ProductSupplier ps = pkg != null ? pkg.getProductSupplier() : null;
        BigDecimal unitPrice = line.getPriceAmount();
        String packageUnits = this.getPackageUnits(invoicedUnitCode, pkg);
        int packageSize = this.getPackageSize(line, pkg);
        BigDecimal listPrice = this.getListPrice(line, product, ps, reorderCode, packageSize, packageUnits, context);
        BigDecimal calcLineExtensionAmount = unitPrice.multiply(quantity);
        if (MathRules.round((BigDecimal)calcLineExtensionAmount, (int)2).compareTo(lineExtensionAmount) != 0) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invoiceLineInvalidLineExtensionAmount(line.getID(), lineExtensionAmount, calcLineExtensionAmount));
        }
        this.checkTax(line, rates);
        deliveryItem.setValue("supplierInvoiceLineId", (Object)line.getMandatoryID());
        deliveryItem.setValue(START_TIME, (Object)startTime);
        deliveryItem.setValue("quantity", (Object)quantity);
        deliveryItem.setValue("unitPrice", (Object)unitPrice);
        deliveryItem.setValue("listPrice", (Object)listPrice);
        deliveryItem.setValue("tax", (Object)tax);
        deliveryItem.setValue("packageUnits", (Object)packageUnits);
        deliveryItem.setValue("packageSize", (Object)packageSize);
        if (product != null) {
            deliveryItem.setTarget("product", (IMObject)product);
        }
        deliveryItem.setValue("reorderCode", (Object)reorderCode);
        deliveryItem.setValue("reorderDescription", (Object)reorderDescription);
        if (orderItem != null) {
            deliveryItem.addTarget("order", (IMObject)orderItem, "deliveries");
        }
        deliveryItem.deriveValues();
        return (FinancialAct)deliveryItem.getObject(FinancialAct.class);
    }

    protected FinancialAct mapCharge(UBLAllowanceCharge charge, Date startTime, String invoiceId, TaxRates rates) {
        if (!charge.isCharge()) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invoiceAllowanceNotSupported(invoiceId));
        }
        BigDecimal unitPrice = charge.getAmount();
        IArchetypeService service = this.getService();
        IMObjectBean deliveryItem = service.getBean((IMObject)service.create("act.supplierDeliveryItem"));
        BigDecimal tax = charge.getTaxAmount();
        UBLTaxCategory taxCategory = charge.getTaxCategory();
        if (taxCategory != null) {
            BigDecimal expectedTax;
            BigDecimal rate = this.checkTaxCategory(taxCategory, rates);
            BigDecimal divisor = BigDecimal.valueOf(100L);
            if (tax.compareTo(BigDecimal.ZERO) != 0 && (expectedTax = MathRules.divide((BigDecimal)unitPrice.multiply(rate), (BigDecimal)divisor, (int)2)).compareTo(tax) != 0) {
                ErrorContext context = new ErrorContext(charge, "TaxTotal/TaxAmount");
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue(context.getPath(), context.getType(), context.getID(), expectedTax.toString(), tax.toString()));
            }
        }
        deliveryItem.setValue(START_TIME, (Object)startTime);
        deliveryItem.setValue("quantity", (Object)BigDecimal.ONE);
        deliveryItem.setValue("packageUnits", null);
        deliveryItem.setValue("unitPrice", (Object)unitPrice);
        deliveryItem.setValue("tax", (Object)tax);
        deliveryItem.setValue("reorderDescription", (Object)charge.getAllowanceChargeReason());
        deliveryItem.deriveValues();
        return (FinancialAct)deliveryItem.getObject(FinancialAct.class);
    }

    protected void checkUBLVersion(UBLInvoice invoice) {
        if (!"2.0".equals(invoice.getUBLVersionID())) {
            throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue("UBLVersionID", "Invoice", invoice.getID(), "2.0", invoice.getUBLVersionID()));
        }
    }

    private BigDecimal getListPrice(UBLInvoiceLine line, Product product, ProductSupplier ps, String reorderCode, int packageSize, String packageUnits, MappingContext context) {
        BigDecimal listPrice = line.getWholesalePrice();
        if (listPrice != null && listPrice.compareTo(BigDecimal.ZERO) == 0) {
            log.warn("Received 0.0 list price from supplier.");
            listPrice = null;
        }
        if (listPrice == null) {
            if (ps == null && product != null) {
                ps = this.productRules.getProductSupplier(product, context.getSupplier(), reorderCode, packageSize, packageUnits);
            }
            if (ps != null) {
                listPrice = ps.getListPrice();
            }
            if (listPrice == null || listPrice.compareTo(BigDecimal.ZERO) == 0) {
                log.warn("Product/supplier list price is 0.0");
            }
        }
        if (listPrice == null || listPrice.compareTo(BigDecimal.ZERO) == 0) {
            listPrice = line.getPriceAmount();
        }
        return listPrice;
    }

    private String getPackageUnits(String invoicedUnitCode, Package pkg) {
        String result = null;
        String expected = pkg != null ? pkg.getPackageUnits() : null;
        List<String> matches = this.packageHelper.getPackageUnits(invoicedUnitCode);
        if (expected != null) {
            if (!matches.contains(expected)) {
                log.warn("Invoice package units ({}) don't match that expected: {}", (Object)StringUtils.join(matches.iterator(), (String)", "), (Object)expected);
            }
            result = expected;
        } else if (matches.size() == 1) {
            result = matches.get(0);
        } else if (matches.size() > 1) {
            log.warn("Cannot determine package units. {} package units match unit code: {}", (Object)matches.size(), (Object)invoicedUnitCode);
        }
        return result;
    }

    private int getPackageSize(UBLInvoiceLine line, Package pkg) {
        int result;
        int invoiceSize;
        BigDecimal packageSize = line.getPackSizeNumeric();
        int expectedSize = pkg != null ? pkg.getPackageSize() : 0;
        try {
            invoiceSize = packageSize.intValueExact();
        }
        catch (ArithmeticException exception) {
            ErrorContext context = new ErrorContext(line, "PackSizeNumeric");
            String intValue = Integer.toString(packageSize.intValue());
            throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue(context.getPath(), context.getType(), context.getID(), intValue, packageSize.toString()));
        }
        if (expectedSize != 0) {
            if (invoiceSize != 0 && invoiceSize != expectedSize) {
                log.warn("Different package size received for invoice. Expected package size={}, invoiced package size={}", (Object)invoiceSize, (Object)expectedSize);
            }
            result = expectedSize;
        } else {
            result = invoiceSize;
        }
        return result;
    }

    private void checkPackQuantity(UBLInvoiceLine line, String unitCode) {
        BigDecimal quantity = line.getPackQuantity();
        if (quantity != null) {
            if (quantity.compareTo(BigDecimal.ONE) != 0) {
                ErrorContext context = new ErrorContext(line, "PackQuantity");
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue(context.getPath(), context.getType(), context.getID(), "1", quantity.toString()));
            }
            String packageUnits = line.getPackQuantityUnitCode();
            if (packageUnits != null && !Objects.equals(unitCode, packageUnits)) {
                ErrorContext context = new ErrorContext(line, "PackQuantity@unitCode");
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue(context.getPath(), context.getType(), context.getID(), unitCode, packageUnits));
            }
        }
    }

    private void checkBaseQuantity(UBLInvoiceLine line, String unitCode) {
        BigDecimal quantity = line.getBaseQuantity();
        if (quantity != null) {
            if (quantity.compareTo(BigDecimal.ONE) != 0) {
                ErrorContext context = new ErrorContext(line, "BaseQuantity");
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue(context.getPath(), context.getType(), context.getID(), "1", quantity.toString()));
            }
            String baseQuantityUnitCode = line.getBaseQuantityUnitCode();
            if (!StringUtils.equals((CharSequence)unitCode, (CharSequence)baseQuantityUnitCode)) {
                ErrorContext context = new ErrorContext(line, "BaseQuantity@unitCode");
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue(context.getPath(), context.getType(), context.getID(), unitCode, baseQuantityUnitCode));
            }
        }
    }
}

