/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.invoice;

import java.util.List;
import java.util.Objects;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.UBLDocument;
import org.openvpms.esci.adapter.map.invoice.MappingContext;
import org.openvpms.esci.adapter.map.invoice.OrderItem;
import org.openvpms.esci.adapter.map.invoice.OrderResolver;
import org.openvpms.esci.adapter.map.invoice.UBLInvoice;
import org.openvpms.esci.adapter.map.invoice.UBLInvoiceLine;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.common.IdentifierType;
import org.openvpms.esci.ubl.common.aggregate.OrderReferenceType;

public class AbstractOrderResolver
implements OrderResolver {
    private final ArchetypeService service;

    public AbstractOrderResolver(ArchetypeService service) {
        this.service = service;
    }

    @Override
    public FinancialAct getOrder(UBLInvoice invoice, Party supplier, Party stockLocation) {
        FinancialAct order = this.getOrder(invoice);
        if (order != null && !this.checkOrder(order, supplier, stockLocation, invoice)) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invalidOrder(invoice.getType(), invoice.getID(), Long.toString(order.getId())));
        }
        return order;
    }

    @Override
    public boolean checkOrder(FinancialAct order, Party supplier, Party stockLocation, UBLDocument document) {
        IMObjectBean bean = this.service.getBean((IMObject)order);
        Reference supplierRef = bean.getTargetRef("supplier");
        Reference locationRef = bean.getTargetRef("stockLocation");
        return Objects.equals(supplierRef, supplier.getObjectReference()) && Objects.equals(locationRef, stockLocation.getObjectReference());
    }

    @Override
    public OrderItem getOrderItem(UBLInvoiceLine line, MappingContext context) {
        FinancialAct lineOrder;
        FinancialAct docOrder = context.getDocumentOrder();
        FinancialAct item = null;
        Reference orderRef = line.getOrderReference();
        Reference orderItemRef = line.getOrderItemReference();
        if (orderItemRef != null) {
            if (orderRef != null) {
                lineOrder = this.getReferencedOrder(orderRef, line, context);
            } else {
                if (docOrder == null) {
                    throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidCardinality("OrderLineReference", "InvoiceLine", line.getID(), "0", 1));
                }
                lineOrder = docOrder;
            }
            if (orderItemRef.getId() != -1L && (item = context.getOrderItem(lineOrder, orderItemRef)) == null) {
                throw new ESCIAdapterException(ESCIAdapterMessages.invoiceInvalidOrderItem(line.getID(), Long.toString(orderItemRef.getId())));
            }
        } else {
            if (orderRef != null) {
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidCardinality("OrderLineReference/LineID", "InvoiceLine", line.getID(), "0", 1));
            }
            lineOrder = docOrder;
        }
        return lineOrder != null ? new OrderItem(lineOrder, item) : null;
    }

    protected FinancialAct getOrder(UBLInvoice invoice) {
        FinancialAct order = null;
        OrderReferenceType orderReference = invoice.getOrderReference();
        if (orderReference != null && (order = (FinancialAct)invoice.getObject("act.supplierOrder", (IdentifierType)orderReference.getID(), "OrderReference")) == null) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invalidOrder("Invoice", invoice.getID(), orderReference.getID().getValue()));
        }
        return order;
    }

    private FinancialAct getReferencedOrder(Reference orderRef, UBLInvoiceLine line, MappingContext context) {
        FinancialAct docOrder;
        FinancialAct childOrder = context.getOrder(orderRef);
        if (childOrder == null) {
            childOrder = line.getOrder();
            this.checkOrder(childOrder, context);
            context.addOrder(childOrder);
            context.addOrderItems(childOrder);
        }
        if ((docOrder = context.getDocumentOrder()) != null && !Objects.equals(docOrder.getObjectReference(), childOrder.getObjectReference())) {
            UBLInvoice invoice = context.getInvoice();
            throw new ESCIAdapterException(ESCIAdapterMessages.invalidOrder(invoice.getType(), invoice.getID(), Long.toString(childOrder.getId())));
        }
        return childOrder;
    }

    private void checkOrder(FinancialAct order, MappingContext context) {
        this.checkOrder(order, context.getSupplier(), context.getStockLocation(), context.getInvoice());
        String invoiceId = context.getInvoice().getMandatoryID();
        IMObjectBean orderBean = this.service.getBean((IMObject)order);
        List deliveries = orderBean.getSources("deliveries", FinancialAct.class);
        for (FinancialAct delivery : deliveries) {
            IMObjectBean deliveryBean = this.service.getBean((IMObject)delivery);
            ActIdentity supplierInvoiceId = (ActIdentity)deliveryBean.getObject("supplierInvoiceId", ActIdentity.class);
            if (supplierInvoiceId == null || !Objects.equals(invoiceId, supplierInvoiceId.getIdentity())) continue;
            throw new ESCIAdapterException(ESCIAdapterMessages.duplicateInvoiceForOrder(invoiceId, order.getId()));
        }
    }
}

