/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.ErrorContext;
import org.openvpms.esci.adapter.map.UBLType;
import org.openvpms.esci.adapter.map.invoice.UBLTaxSubtotal;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.common.AmountType;
import org.openvpms.esci.ubl.common.CurrencyCodeContentType;
import org.openvpms.esci.ubl.common.QuantityType;
import org.openvpms.esci.ubl.common.aggregate.TaxSubtotalType;
import org.openvpms.esci.ubl.common.aggregate.TaxTotalType;

public abstract class UBLFinancialType
extends UBLType {
    private final String currency;

    protected UBLFinancialType(UBLType parent, String currency, IArchetypeService service) {
        super(parent, service);
        this.currency = currency;
    }

    protected String getCurrency() {
        return this.currency;
    }

    protected BigDecimal getTaxAmount(List<TaxTotalType> tax) {
        BigDecimal result = BigDecimal.ZERO;
        TaxTotalType total = this.getTaxTotal(tax);
        if (total != null) {
            result = this.getAmount((AmountType)total.getTaxAmount(), "TaxTotal/TaxAmount");
        }
        return result;
    }

    protected TaxTotalType getTaxTotal(List<TaxTotalType> tax) {
        TaxTotalType result = null;
        if (tax != null && !tax.isEmpty()) {
            if (tax.size() != 1) {
                ErrorContext context = new ErrorContext(this, "TaxTotal");
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidCardinality(context.getPath(), context.getType(), context.getID(), "1", tax.size()));
            }
            result = tax.get(0);
        }
        return result;
    }

    protected UBLTaxSubtotal getTaxSubtotal(List<TaxTotalType> tax) {
        UBLTaxSubtotal result = null;
        TaxTotalType total = this.getTaxTotal(tax);
        if (total != null) {
            result = this.getTaxSubtotal(total);
        }
        return result;
    }

    protected UBLTaxSubtotal getTaxSubtotal(TaxTotalType tax) {
        UBLTaxSubtotal result = null;
        if (tax != null) {
            List taxSubtotal = tax.getTaxSubtotal();
            if (taxSubtotal.size() != 1) {
                ErrorContext context = new ErrorContext(this, "TaxTotal/TaxSubtotal");
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidCardinality(context.getPath(), context.getType(), context.getID(), "1", taxSubtotal.size()));
            }
            result = new UBLTaxSubtotal((TaxSubtotalType)taxSubtotal.get(0), this, this.getCurrency(), this.getArchetypeService());
        }
        return result;
    }

    protected BigDecimal getAmount(AmountType amount, String path) {
        this.checkRequired(amount, path);
        this.checkRequired(amount.getValue(), path);
        CurrencyCodeContentType code = this.getRequired(amount.getCurrencyID(), path + "@currencyID");
        if (!Objects.equals(this.currency, code.value())) {
            ErrorContext context = new ErrorContext(this, path);
            throw new ESCIAdapterException(ESCIAdapterMessages.invalidCurrency(context.getPath(), context.getType(), context.getID(), this.currency, code.value()));
        }
        BigDecimal result = amount.getValue();
        if (result.signum() == -1) {
            ErrorContext context = new ErrorContext(this, path);
            throw new ESCIAdapterException(ESCIAdapterMessages.invalidAmount(context.getPath(), context.getType(), context.getID(), result));
        }
        return amount.getValue();
    }

    protected BigDecimal getQuantity(QuantityType quantity, String path) {
        this.checkRequired(quantity, path);
        this.checkRequired(quantity.getValue(), path);
        BigDecimal result = quantity.getValue();
        if (result.compareTo(BigDecimal.ZERO) <= 0) {
            ErrorContext context = new ErrorContext(this, path);
            throw new ESCIAdapterException(ESCIAdapterMessages.invalidQuantity(context.getPath(), context.getType(), context.getID(), result));
        }
        return result;
    }
}

