/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.dispatcher.invoice;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.security.AuthenticationContext;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.dispatcher.DocumentProcessor;
import org.openvpms.esci.adapter.dispatcher.InboxDocument;
import org.openvpms.esci.adapter.dispatcher.ProcessingConfig;
import org.openvpms.esci.adapter.dispatcher.invoice.InvoiceListener;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.invoice.DefaultOrderResolver;
import org.openvpms.esci.adapter.map.invoice.Delivery;
import org.openvpms.esci.adapter.map.invoice.InvoiceMapper;
import org.openvpms.esci.adapter.map.invoice.OrderResolver;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.invoice.InvoiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceProcessor
implements DocumentProcessor {
    private final IArchetypeService service;
    private final InvoiceMapper mapper;
    private final InvoiceListener listener;
    private final AuthenticationContext context;
    private static final Logger log = LoggerFactory.getLogger(InvoiceProcessor.class);

    public InvoiceProcessor(IArchetypeService service, InvoiceMapper mapper, InvoiceListener listener, AuthenticationContext context) {
        this.service = service;
        this.mapper = mapper;
        this.listener = listener;
        this.context = context;
    }

    @Override
    public boolean canHandle(InboxDocument document) {
        return document.getContent() instanceof InvoiceType;
    }

    @Override
    public void process(InboxDocument document, Party supplier, Party stockLocation, String accountId, ProcessingConfig config) {
        InvoiceType invoice = (InvoiceType)document.getContent();
        User user = this.context.getUser();
        try {
            OrderResolver resolver;
            if (user == null) {
                this.setAuthenticationContext(stockLocation);
            }
            OrderResolver orderResolver = resolver = config != null ? config.getOrderResolver() : null;
            if (resolver == null) {
                resolver = new DefaultOrderResolver((ArchetypeService)this.service);
            }
            Delivery delivery = this.mapper.map(invoice, supplier, stockLocation, accountId, resolver);
            this.service.save(delivery.getActs());
            this.notifyListener(delivery.getDelivery());
        }
        catch (Exception exception) {
            String invoiceId = invoice.getID() != null ? invoice.getID().getValue() : null;
            Message message = ESCIAdapterMessages.failedToProcessInvoice(invoiceId, supplier, stockLocation, exception.getMessage());
            throw new ESCIAdapterException(message, exception);
        }
        finally {
            if (user == null) {
                this.context.setUser(null);
            }
        }
    }

    protected void notifyListener(FinancialAct delivery) {
        InvoiceListener l = this.listener;
        if (l != null) {
            try {
                l.receivedInvoice(delivery);
            }
            catch (Exception exception) {
                log.error("InvoiceListener threw exception", (Throwable)exception);
            }
        }
    }

    private void setAuthenticationContext(Party stockLocation) {
        IMObjectBean bean = this.service.getBean((IMObject)stockLocation);
        User defaultAuthor = (User)bean.getTarget("defaultAuthor", User.class, Policies.active());
        if (defaultAuthor != null) {
            this.context.setUser(defaultAuthor);
        }
    }
}

