/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.dispatcher;

import java.util.Iterator;
import java.util.List;
import org.openvpms.component.model.party.Party;
import org.openvpms.esci.adapter.dispatcher.DocumentProcessor;
import org.openvpms.esci.adapter.dispatcher.Inbox;
import org.openvpms.esci.adapter.dispatcher.InboxDocument;
import org.openvpms.esci.adapter.dispatcher.ProcessingConfig;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.service.exception.DocumentNotFoundException;
import org.openvpms.esci.ubl.common.Document;
import org.openvpms.esci.ubl.common.aggregate.DocumentReferenceType;

public class InboxDispatcher {
    private final Inbox inbox;
    private final List<DocumentProcessor> processors;
    private Iterator<DocumentReferenceType> references;

    public InboxDispatcher(Inbox inbox, List<DocumentProcessor> processors) {
        this.inbox = inbox;
        this.processors = processors;
    }

    public boolean hasNext() {
        if (this.references == null || !this.references.hasNext()) {
            this.references = this.inbox.getDocuments().iterator();
        }
        return this.references.hasNext();
    }

    public boolean dispatch() {
        boolean result = false;
        if (this.hasNext()) {
            DocumentReferenceType reference = this.references.next();
            this.process(reference, null);
            result = true;
        }
        return result;
    }

    public void process(DocumentReferenceType reference, ProcessingConfig config) {
        Document doc = this.inbox.getDocument(reference);
        if (doc != null) {
            InboxDocument wrapper = new InboxDocument(reference, doc.getAny());
            DocumentProcessor processor = this.getProcessor(this.inbox.getSupplier(), wrapper);
            processor.process(wrapper, this.inbox.getSupplier(), this.inbox.getStockLocation(), this.inbox.getAccountId(), config);
            try {
                this.inbox.acknowledge(reference);
            }
            catch (DocumentNotFoundException exception) {
                throw new ESCIAdapterException(ESCIAdapterMessages.failedToAcknowledgeDocument(this.inbox.getSupplier(), reference));
            }
        } else {
            throw new ESCIAdapterException(ESCIAdapterMessages.documentNotFound(this.inbox.getSupplier(), reference));
        }
    }

    public void delete(DocumentReferenceType reference) {
        try {
            this.inbox.acknowledge(reference);
        }
        catch (DocumentNotFoundException exception) {
            throw new ESCIAdapterException(ESCIAdapterMessages.documentNotFound(this.inbox.getSupplier(), reference));
        }
    }

    protected DocumentProcessor getProcessor(Party supplier, InboxDocument document) {
        for (DocumentProcessor documentProcessor : this.processors) {
            if (!documentProcessor.canHandle(document)) continue;
            return documentProcessor;
        }
        throw new ESCIAdapterException(ESCIAdapterMessages.unsupportedDocument(supplier, document.getDocumentReference(), document.getContent()));
    }
}

