/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.dispatcher;

import java.util.List;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ESCIConfig {
    private final IMObjectBean bean;
    private final Party supplier;
    private final Party stockLocation;

    public ESCIConfig(EntityRelationship config, Party supplier, Party stockLocation, ArchetypeService service) {
        this.bean = service.getBean((IMObject)config);
        this.supplier = supplier;
        this.stockLocation = stockLocation;
    }

    public String getAccountId() {
        return this.bean.getString("accountId");
    }

    public String getUsername() {
        return this.bean.getString("username");
    }

    public String getPassword() {
        return this.bean.getString("password");
    }

    public String getServiceURL() {
        return this.bean.getString("serviceURL");
    }

    public Party getSupplier() {
        return this.supplier;
    }

    public Party getStockLocation() {
        return this.stockLocation;
    }

    public static ESCIConfig create(Party supplier, Party stockLocation, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)supplier);
        List relationships = bean.getValues("stockLocations", EntityRelationship.class, Predicates.isA((String[])new String[]{"entityRelationship.supplierStockLocationESCI"}).and(Predicates.activeNow().and(Predicates.targetEquals((IMObject)stockLocation))));
        return !relationships.isEmpty() ? new ESCIConfig((EntityRelationship)relationships.get(0), supplier, stockLocation, service) : null;
    }
}

