/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.dispatcher;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSystemMessageFactory {
    private final IArchetypeService service;
    private static final Logger log = LoggerFactory.getLogger(AbstractSystemMessageFactory.class);

    protected AbstractSystemMessageFactory(IArchetypeService service) {
        this.service = service;
    }

    protected void createMessage(Act act, String subject, String reason) {
        User user = this.getAddressee(act, reason);
        if (user != null) {
            IMObjectBean message = this.service.getBean(this.service.create("act.systemMessage", Act.class));
            message.addTarget("item", (IMObject)act);
            message.setTarget("to", (IMObject)user);
            message.setValue("description", (Object)subject);
            message.setValue("reason", (Object)reason);
            message.save();
        }
    }

    protected User getAddressee(Act act, String reason) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        User result = null;
        if (act.getCreatedBy() != null) {
            result = (User)this.service.get(act.getCreatedBy(), User.class);
        }
        Entity stockLocation = null;
        if (result == null && bean.hasNode("stockLocation") && (stockLocation = (Entity)bean.getTarget("stockLocation", Entity.class)) != null) {
            IMObjectBean locBean = this.service.getBean((IMObject)stockLocation);
            result = (User)locBean.getTarget("defaultAuthor");
        }
        if (result == null && log.isInfoEnabled()) {
            StringBuilder message = new StringBuilder("Cannot create ");
            message.append("act.systemMessage");
            message.append(" for ");
            message.append(act.getArchetype());
            message.append(":");
            message.append(act.getId());
            message.append(" with reason ");
            message.append(reason);
            message.append(". The act has no author");
            if (stockLocation != null) {
                message.append(" and stock location ");
                message.append(stockLocation.getName());
                message.append(" has no defaultAuthor configured");
            }
            log.info(message.toString());
        }
        return result;
    }

    protected IArchetypeService getService() {
        return this.service;
    }
}

