/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.invoice;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.map.UBLFinancialType;
import org.openvpms.esci.adapter.map.UBLType;
import org.openvpms.esci.ubl.common.IdentifierType;
import org.openvpms.esci.ubl.common.aggregate.TaxCategoryType;
import org.openvpms.esci.ubl.common.aggregate.TaxSchemeType;
import org.openvpms.esci.ubl.common.basic.PercentType;
import org.openvpms.esci.ubl.common.basic.TaxTypeCodeType;

public class UBLTaxCategory
extends UBLFinancialType {
    private final TaxCategoryType category;

    public UBLTaxCategory(TaxCategoryType category, UBLType parent, String currency, ArchetypeService service) {
        super(parent, currency, service);
        this.category = category;
    }

    @Override
    public String getType() {
        return "TaxCategory";
    }

    @Override
    public String getID() {
        return this.getId((IdentifierType)this.category.getID());
    }

    public BigDecimal getTaxRate() {
        PercentType percent = this.getRequired(this.category.getPercent(), "Percent");
        return this.getRequired(percent.getValue(), "Percent");
    }

    public String getTaxTypeCode() {
        TaxSchemeType scheme = this.getRequired(this.category.getTaxScheme(), "TaxScheme");
        TaxTypeCodeType result = this.getRequired(scheme.getTaxTypeCode(), "TaxScheme/TaxTypeCode");
        return this.getRequired(StringUtils.trimToNull((String)result.getValue()), "TaxScheme/TaxTypeCode");
    }
}

