/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.dispatcher;

import java.util.Iterator;
import java.util.List;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.client.SupplierServiceLocator;
import org.openvpms.esci.adapter.dispatcher.DocumentProcessor;
import org.openvpms.esci.adapter.dispatcher.ESCIConfig;
import org.openvpms.esci.adapter.dispatcher.ESCIDispatcher;
import org.openvpms.esci.adapter.dispatcher.ESCISuppliers;
import org.openvpms.esci.adapter.dispatcher.ErrorHandler;
import org.openvpms.esci.adapter.dispatcher.Inbox;
import org.openvpms.esci.adapter.dispatcher.InboxDispatcher;
import org.openvpms.esci.adapter.dispatcher.ProcessingConfig;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.service.InboxService;
import org.openvpms.esci.ubl.common.aggregate.DocumentReferenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultESCIDispatcher
implements ESCIDispatcher {
    private final SupplierServiceLocator locator;
    private final List<DocumentProcessor> processors;
    private final ArchetypeService service;
    private volatile boolean stop;
    private static final Logger log = LoggerFactory.getLogger(DefaultESCIDispatcher.class);

    public DefaultESCIDispatcher(SupplierServiceLocator locator, List<DocumentProcessor> processors, ArchetypeService service) {
        this.locator = locator;
        this.processors = processors;
        this.service = service;
    }

    @Override
    public void dispatch(boolean lenientOrderProcessing) {
        this.dispatch(lenientOrderProcessing, new ErrorHandler(){

            @Override
            public boolean terminateOnError() {
                return false;
            }

            @Override
            public void error(Throwable exception) {
                log.error(exception.getMessage(), exception);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int dispatch(boolean lenientOrderProcessing, ErrorHandler handler) {
        int result = 0;
        try {
            List<ESCIConfig> suppliers = this.getConfigs();
            Iterator<ESCIConfig> iterator = suppliers.iterator();
            while (!this.stop && iterator.hasNext()) {
                ESCIConfig config = iterator.next();
                Inbox inbox = this.getInbox(config, handler);
                if (inbox == null) continue;
                result += this.dispatch(inbox, lenientOrderProcessing, handler);
            }
        }
        finally {
            this.stop = false;
        }
        return result;
    }

    @Override
    public synchronized void process(Inbox inbox, DocumentReferenceType reference, ProcessingConfig config) {
        InboxDispatcher dispatcher = new InboxDispatcher(inbox, this.processors, this.service);
        dispatcher.process(reference, config);
    }

    @Override
    public synchronized void delete(Inbox inbox, DocumentReferenceType reference) {
        InboxDispatcher dispatcher = new InboxDispatcher(inbox, this.processors, this.service);
        dispatcher.delete(reference);
    }

    @Override
    public synchronized int dispatch(Inbox inbox, boolean lenientOrderProcessing, ErrorHandler handler) {
        int result;
        block5: {
            result = 0;
            try {
                InboxDispatcher dispatcher = new InboxDispatcher(inbox, this.processors, this.service);
                while (!this.stop && dispatcher.hasNext()) {
                    if (!dispatcher.dispatch(lenientOrderProcessing)) continue;
                    ++result;
                }
            }
            catch (ESCIAdapterException exception) {
                handler.error((Throwable)((Object)exception));
                if (handler.terminateOnError()) {
                    throw exception;
                }
            }
            catch (Exception cause) {
                ESCIAdapterException exception = new ESCIAdapterException(ESCIAdapterMessages.failedToProcessInbox(inbox.getSupplier(), inbox.getStockLocation(), cause.getMessage()), cause);
                handler.error((Throwable)((Object)exception));
                if (!handler.terminateOnError()) break block5;
                throw exception;
            }
        }
        return result;
    }

    @Override
    public void stop() {
        this.stop = true;
    }

    protected List<ESCIConfig> getConfigs() {
        ESCISuppliers helper = new ESCISuppliers(this.service);
        return helper.getESCIConfigs();
    }

    private Inbox getInbox(ESCIConfig config, ErrorHandler handler) {
        Inbox result;
        block4: {
            result = null;
            try {
                InboxService inboxService = this.locator.getInboxService(config);
                result = new Inbox(config, inboxService);
            }
            catch (ESCIAdapterException exception) {
                handler.error((Throwable)((Object)exception));
                if (handler.terminateOnError()) {
                    throw exception;
                }
            }
            catch (Exception cause) {
                ESCIAdapterException exception = new ESCIAdapterException(ESCIAdapterMessages.failedToProcessInbox(config.getSupplier(), config.getStockLocation(), cause.getMessage()), cause);
                handler.error((Throwable)((Object)exception));
                if (!handler.terminateOnError()) break block4;
                throw exception;
            }
        }
        return result;
    }
}

