/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.client.jaxws;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.openvpms.esci.adapter.client.SupplierServiceLocator;
import org.openvpms.esci.adapter.dispatcher.ESCIConfig;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.service.InboxService;
import org.openvpms.esci.service.OrderService;
import org.openvpms.esci.service.RegistryService;
import org.openvpms.esci.service.client.ServiceLocator;
import org.openvpms.esci.service.client.ServiceLocatorFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.jaxws.JaxWsSoapFaultException;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class SupplierWebServiceLocator
implements SupplierServiceLocator,
DisposableBean {
    private final PasswordEncryptor encryptor;
    private final ServiceLocatorFactory locatorFactory;
    private final int timeout;
    private final ExecutorService executor;

    public SupplierWebServiceLocator(PasswordEncryptor encryptor, ServiceLocatorFactory factory) {
        this(encryptor, factory, 30);
    }

    public SupplierWebServiceLocator(PasswordEncryptor encryptor, ServiceLocatorFactory factory, int timeout) {
        this.encryptor = encryptor;
        this.locatorFactory = factory;
        this.timeout = timeout;
        this.executor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("ESCI-"));
    }

    @Override
    public OrderService getOrderService(ESCIConfig config) {
        SupplierServices services = new SupplierServices(config);
        return services.getOrderService();
    }

    @Override
    public OrderService getOrderService(String serviceURL, String username, String password) {
        SupplierServices services = new SupplierServices(serviceURL, username, password);
        return services.getOrderService();
    }

    @Override
    public InboxService getInboxService(ESCIConfig config) {
        SupplierServices services = new SupplierServices(config);
        return services.getInboxService();
    }

    public void destroy() throws Exception {
        this.executor.shutdown();
    }

    protected class SupplierServices {
        private final Party supplier;
        private final String serviceURL;
        private final String username;
        private final String password;

        public SupplierServices(ESCIConfig config) {
            this.supplier = config.getSupplier();
            this.username = config.getUsername();
            String encrypted = config.getPassword();
            if (encrypted != null) {
                try {
                    this.password = SupplierWebServiceLocator.this.encryptor.decrypt(encrypted);
                }
                catch (Exception exception) {
                    throw new ESCIAdapterException(ESCIAdapterMessages.failedToDecryptPassword(this.supplier, config.getStockLocation()));
                }
            } else {
                this.password = null;
            }
            this.serviceURL = config.getServiceURL();
            if (StringUtils.isEmpty((CharSequence)this.serviceURL)) {
                throw new ESCIAdapterException(ESCIAdapterMessages.invalidSupplierURL(this.supplier, this.serviceURL));
            }
        }

        public SupplierServices(String serviceURL, String username, String password) {
            this.supplier = null;
            this.serviceURL = serviceURL;
            this.username = username;
            this.password = password;
        }

        public RegistryService getRegistryService() {
            return this.getRegistryService(null);
        }

        public RegistryService getRegistryService(String endpointAddress) {
            return this.getService(RegistryService.class, this.serviceURL, endpointAddress);
        }

        public OrderService getOrderService() {
            return this.getOrderService(null, null);
        }

        public OrderService getOrderService(String orderEndpointAddress, String registryEndpointAddress) {
            String order;
            RegistryService registry = this.getRegistryService(registryEndpointAddress);
            try {
                order = registry.getOrderService();
            }
            catch (ESCIAdapterException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new ESCIAdapterException(this.getConnectionFailed(), exception);
            }
            return this.getService(OrderService.class, order, orderEndpointAddress);
        }

        public InboxService getInboxService() {
            return this.getInboxService(null);
        }

        public InboxService getInboxService(String endpointAddress) {
            String inbox;
            RegistryService registry = this.getRegistryService();
            try {
                inbox = registry.getInboxService();
            }
            catch (ESCIAdapterException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new ESCIAdapterException(this.getConnectionFailed(), exception);
            }
            return this.getService(InboxService.class, inbox, endpointAddress);
        }

        protected <T> T proxy(T service, Class<T> type) {
            InvocationHandler handler = (proxy, method, args) -> {
                Object result;
                Callable<Object> callable = () -> method.invoke(service, args);
                try {
                    result = this.invokeWithTimeout(callable);
                }
                catch (ExecutionException exception) {
                    Throwable cause = exception.getCause();
                    if (cause instanceof InvocationTargetException) {
                        cause = cause.getCause();
                    }
                    if (cause instanceof JaxWsSoapFaultException) {
                        cause = cause.getCause();
                        throw new ESCIAdapterException(ESCIAdapterMessages.remoteServiceError(cause.getMessage()), cause);
                    }
                    if (cause instanceof RemoteAccessException) {
                        cause = cause.getCause();
                        throw new ESCIAdapterException(this.getConnectionFailed(), cause);
                    }
                    throw cause;
                }
                return result;
            };
            return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler);
        }

        private <T> T getService(Class<T> clazz, String url, String endpointAddress) {
            Object service;
            if (SupplierWebServiceLocator.this.timeout > 0) {
                try {
                    service = this.invokeWithTimeout(() -> this.doGetService(clazz, url, endpointAddress));
                }
                catch (ExecutionException exception) {
                    Throwable cause = exception.getCause();
                    if (cause instanceof InvocationTargetException) {
                        cause = cause.getCause();
                    }
                    throw new ESCIAdapterException(this.getConnectionFailed(), cause);
                }
                service = this.proxy(service, clazz);
            } else {
                try {
                    service = this.doGetService(clazz, url, endpointAddress);
                }
                catch (ESCIAdapterException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    throw new ESCIAdapterException(this.getConnectionFailed(), exception);
                }
            }
            return service;
        }

        protected <T> T doGetService(Class<T> clazz, String url, String endpointAddress) {
            ServiceLocator locator;
            try {
                locator = SupplierWebServiceLocator.this.locatorFactory.getServiceLocator(clazz, url, endpointAddress, this.username, this.password);
            }
            catch (MalformedURLException exception) {
                Message message = this.supplier != null ? ESCIAdapterMessages.invalidSupplierURL(this.supplier, this.serviceURL) : ESCIAdapterMessages.invalidServiceURL(this.serviceURL);
                throw new ESCIAdapterException(message, exception);
            }
            try {
                return (T)locator.getService();
            }
            catch (WebServiceException exception) {
                throw new ESCIAdapterException(this.getConnectionFailed(), exception);
            }
        }

        private <T> T invokeWithTimeout(Callable<T> callable) throws ExecutionException, ESCIAdapterException {
            T result;
            try {
                result = SupplierWebServiceLocator.this.executor.invokeAny(Collections.singletonList(callable), SupplierWebServiceLocator.this.timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException | TimeoutException exception) {
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (this.supplier != null) {
                    throw new ESCIAdapterException(ESCIAdapterMessages.connectionTimedOut(this.supplier, this.serviceURL), exception);
                }
                throw new ESCIAdapterException(ESCIAdapterMessages.connectionTimedOut(this.serviceURL), exception);
            }
            return result;
        }

        private Message getConnectionFailed() {
            return this.supplier != null ? ESCIAdapterMessages.connectionFailed(this.supplier, this.serviceURL) : ESCIAdapterMessages.connectionFailed(this.serviceURL);
        }
    }
}

