/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2025 (C) OpenVPMS Ltd. All Rights Reserved.
 */
package org.openvpms.esci.adapter.map.order;

import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.esci.ubl.order.OrderResponseSimpleType;


/**
 * Maps UBL order responses to their corresponding orders.
 *
 * @author Tim Anderson
 */
public interface OrderResponseMapper {

    /**
     * Maps an {@code OrderResponseSimpleType} to its corresponding order.
     *
     * @param response      the response
     * @param supplier      the supplier that submitted the response
     * @param stockLocation the stock location
     * @param accountId     the supplier assigned account identifier. May be {@code null}
     * @return the corresponding order
     * @throws DuplicateOrderResponseException if the response is for an order that has already been ACCEPTED or
     * REJECTED
     */
    FinancialAct map(OrderResponseSimpleType response, Party supplier, Party stockLocation, String accountId);

}
