/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2020 (C) OpenVPMS Ltd. All Rights Reserved.
 */
package org.openvpms.esci.adapter.dispatcher.order;

import org.openvpms.component.model.act.FinancialAct;


/**
 * A listener for order responses received by the {@link OrderResponseProcessor}.
 *
 * @author Tim Anderson
 */
public interface OrderResponseListener {

    /**
     * Invoked after a response is received for an order.
     *
     * @param order the order
     */
    void receivedResponse(FinancialAct order);

}
