/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2025 (C) OpenVPMS Ltd. All Rights Reserved.
 */
package org.openvpms.esci.adapter.dispatcher.invoice;

import org.openvpms.archetype.rules.workflow.SystemMessageReason;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.dispatcher.AbstractSystemMessageFactory;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;

import java.util.List;


/**
 * An {@link InvoiceListener} that creates a new <em>act.systemMessage</em> with a link to the
 * <em>act.supplierDelivery</em>, and addressed to the author of the delivery.
 * <p/>
 * If the delivery has no author participation and there is no default author associated with the
 * delivery's stock location, then no message is created.
 *
 * @author Tim Anderson
 */
public class SystemMessageInvoiceListener extends AbstractSystemMessageFactory implements InvoiceListener {

    /**
     * Constructs a {@link SystemMessageInvoiceListener}.
     *
     * @param service the archetype service
     */
    public SystemMessageInvoiceListener(ArchetypeService service) {
        super(service);
    }

    /**
     * Invoked when an invoice has been received and mapped to a delivery.
     *
     * @param delivery the delivery
     * @param warnings any warnings generated when processing the invoice
     */
    public void receivedInvoice(FinancialAct delivery, List<String> warnings) {
        String subject = ESCIAdapterMessages.orderInvoiced().getMessage();
        String message = null;
        if (!warnings.isEmpty()) {
            message = ESCIAdapterMessages.invoiceProcessedWithWarnings(warnings).getMessage();
        }
        createMessage(delivery, subject, SystemMessageReason.ORDER_INVOICED, message);
    }
}
