/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.invoice;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.UBLFinancialType;
import org.openvpms.esci.adapter.map.invoice.UBLInvoice;
import org.openvpms.esci.adapter.map.invoice.UBLTaxCategory;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.common.AmountType;
import org.openvpms.esci.ubl.common.IdentifierType;
import org.openvpms.esci.ubl.common.aggregate.AllowanceChargeType;
import org.openvpms.esci.ubl.common.aggregate.TaxCategoryType;
import org.openvpms.esci.ubl.common.aggregate.TaxTotalType;
import org.openvpms.esci.ubl.common.basic.AllowanceChargeReasonType;

public class UBLAllowanceCharge
extends UBLFinancialType {
    private final AllowanceChargeType allowanceCharge;
    private final UBLInvoice invoice;

    public UBLAllowanceCharge(AllowanceChargeType allowanceCharge, UBLInvoice invoice, String currency, ArchetypeService service) {
        super(invoice, currency, service);
        this.allowanceCharge = allowanceCharge;
        this.invoice = invoice;
    }

    @Override
    public String getType() {
        return "AllowanceCharge";
    }

    @Override
    public String getID() {
        return this.getId((IdentifierType)this.allowanceCharge.getID());
    }

    public boolean isCharge() {
        return this.getRequired(this.allowanceCharge.getChargeIndicator(), "ChargeIndicator").isValue();
    }

    public BigDecimal getAmount() {
        return this.getAmount((AmountType)this.allowanceCharge.getAmount(), "Amount");
    }

    public BigDecimal getTaxAmount() {
        BigDecimal result = BigDecimal.ZERO;
        TaxTotalType taxTotal = this.allowanceCharge.getTaxTotal();
        if (taxTotal != null) {
            result = this.getAmount((AmountType)taxTotal.getTaxAmount(), "TaxTotal/TaxAmount");
        }
        return result;
    }

    public String getAllowanceChargeReason() {
        AllowanceChargeReasonType reason = this.getRequired(this.allowanceCharge.getAllowanceChargeReason(), "AllowanceChargeReason");
        String result = StringUtils.trimToNull((String)reason.getValue());
        this.checkRequired(result, "AllowanceChargeReason");
        return result;
    }

    public UBLTaxCategory getTaxCategory() {
        UBLTaxCategory result = null;
        List categories = this.allowanceCharge.getTaxCategory();
        if (!categories.isEmpty()) {
            if (categories.size() != 1) {
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidCardinality("AllowanceCharge/TaxCategory", "Invoice", this.invoice.getID(), "1", categories.size()));
            }
            result = new UBLTaxCategory((TaxCategoryType)categories.get(0), this, this.getCurrency(), this.getArchetypeService());
        } else if (this.allowanceCharge.getTaxTotal() != null) {
            throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidCardinality("AllowanceCharge/TaxCategory", "Invoice", this.invoice.getID(), "1", categories.size()));
        }
        return result;
    }
}

