/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map;

import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.UBLDocument;
import org.openvpms.esci.adapter.map.invoice.DefaultOrderResolver;
import org.openvpms.esci.adapter.util.ESCIAdapterException;

public class AbstractUBLMapper {
    protected static final String UBL_VERSION = "2.0";
    private final ArchetypeService service;

    public AbstractUBLMapper(ArchetypeService service) {
        this.service = service;
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    protected void checkUBLVersion(UBLDocument document) {
        String version = document.getUBLVersionID();
        if (!UBL_VERSION.equals(version)) {
            throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue("UBLVersionID", document.getType(), document.getID(), UBL_VERSION, version));
        }
    }

    protected void checkOrder(FinancialAct order, Party supplier, Party stockLocation, UBLDocument document) {
        DefaultOrderResolver resolver = new DefaultOrderResolver(this.service);
        if (!resolver.checkOrder(order, supplier, stockLocation, document)) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invalidOrder(document.getType(), document.getID(), Long.toString(order.getId())));
        }
    }
}

