/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.i18n;

import java.math.BigDecimal;
import java.util.List;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.i18n.Messages;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.esci.ubl.common.aggregate.DocumentReferenceType;

public class ESCIAdapterMessages {
    private static final Messages messages = new Messages("ESCIA", ESCIAdapterMessages.class.getName());

    private ESCIAdapterMessages() {
    }

    public static Message ESCINotConfigured(Party supplier, Party stockLocation) {
        return messages.create(1, new Object[]{supplier.getId(), supplier.getName(), stockLocation.getId(), stockLocation.getName()});
    }

    public static Message invalidSupplierURL(Party supplier, String serviceURL) {
        return messages.create(2, new Object[]{supplier.getId(), supplier.getName(), serviceURL});
    }

    public static Message invalidServiceURL(String serviceURL) {
        return messages.create(3, new Object[]{serviceURL});
    }

    public static Message connectionFailed(String serviceURL) {
        return messages.create(4, new Object[]{serviceURL});
    }

    public static Message connectionFailed(Party supplier, String serviceURL) {
        return messages.create(5, new Object[]{supplier.getId(), supplier.getName(), serviceURL});
    }

    public static Message connectionTimedOut(String serviceURL) {
        return messages.create(6, new Object[]{serviceURL});
    }

    public static Message connectionTimedOut(Party supplier, String serviceURL) {
        return messages.create(7, new Object[]{supplier.getId(), supplier.getName(), serviceURL});
    }

    public static Message remoteServiceError(String cause) {
        return messages.create(8, new Object[]{cause});
    }

    public static Message failedToDecryptPassword(Party supplier, Party stockLocation) {
        return messages.create(9, new Object[]{supplier.getId(), supplier.getName(), stockLocation.getId(), stockLocation.getName()});
    }

    public static Message ublElementRequired(String path, String parent) {
        return messages.create(99, new Object[]{path, parent});
    }

    public static Message ublElementRequired(String path, String parent, String id) {
        return messages.create(100, new Object[]{path, parent, id});
    }

    public static Message ublInvalidCardinality(String path, String parent, String id, String expected, int actual) {
        return messages.create(101, new Object[]{path, parent, id, expected, actual});
    }

    public static Message ublInvalidIdentifier(String path, String parent, String parentId, String value) {
        return messages.create(102, new Object[]{path, parent, parentId, value});
    }

    public static Message ublInvalidValue(String path, String parent, String parentId, String expected, String actual) {
        return messages.create(103, new Object[]{path, parent, parentId, expected, actual});
    }

    public static Message invalidAmount(String path, String parent, String parentId, BigDecimal amount) {
        return messages.create(104, new Object[]{path, parent, parentId, amount});
    }

    public static Message invalidCurrency(String path, String parent, String parentId, String expected, String actual) {
        return messages.create(105, new Object[]{path, parent, parentId, expected, actual});
    }

    public static Message invalidQuantity(String path, String parent, String parentId, BigDecimal quantity) {
        return messages.create(106, new Object[]{path, parent, parentId, quantity});
    }

    public static Message invalidSupplier(String path, String parent, String parentId, String supplierId) {
        return messages.create(107, new Object[]{path, parent, parentId, supplierId});
    }

    public static Message invalidOrder(String parent, String parentId, String orderId) {
        return messages.create(108, new Object[]{parent, parentId, orderId});
    }

    public static Message supplierMismatch(String path, String parent, String parentId, Party expectedSupplier, Party actualSupplier) {
        return messages.create(109, new Object[]{path, parent, parentId, expectedSupplier.getId(), expectedSupplier.getName(), actualSupplier.getId(), actualSupplier.getName()});
    }

    public static Message invalidTaxSchemeAndCategory(String path, String parent, String id, String schemeId, String categoryId) {
        return messages.create(110, new Object[]{path, parent, id, schemeId, categoryId});
    }

    public static Message noCustomerOrAdditionalAccountId(String path, String parent, String id) {
        return messages.create(111, new Object[]{path, parent, id});
    }

    public static Message noCustomerOrSupplierAccountId(String path, String parent, String id) {
        return messages.create(112, new Object[]{path, parent, id});
    }

    public static Message invalidStockLocation(String path, String parent, String id, String stockLocationId) {
        return messages.create(113, new Object[]{path, parent, id, stockLocationId});
    }

    public static Message stockLocationMismatch(String path, String parent, String parentId, Party expectedStockLocation, Party actualStockLocation) {
        return messages.create(114, new Object[]{path, parent, parentId, expectedStockLocation.getId(), expectedStockLocation.getName(), actualStockLocation.getId(), actualStockLocation.getName()});
    }

    public static Message amountTooManyDecimalPlaces(BigDecimal amount) {
        return messages.create(115, new Object[]{amount});
    }

    public static Message quantityTooManyDecimalPlaces(BigDecimal quantity) {
        return messages.create(116, new Object[]{quantity});
    }

    public static Message duplicateOrder(long id, Party supplier) {
        return messages.create(200, new Object[]{id, supplier.getId(), supplier.getName()});
    }

    public static Message noSupplierOrderCode(Party supplier, Product product) {
        return messages.create(300, new Object[]{supplier.getId(), supplier.getName(), product.getId(), product.getName()});
    }

    public static Message noPracticeLocationForStockLocation(Party stockLocation) {
        return messages.create(301, new Object[]{stockLocation.getId(), stockLocation.getName()});
    }

    public static Message orderAccepted() {
        return messages.create(400, new Object[0]);
    }

    public static Message orderRejected(String reason) {
        return messages.create(401, new Object[]{reason});
    }

    public static Message orderRejectedNoReason() {
        return messages.create(402, new Object[0]);
    }

    public static Message duplicateOrderResponse(long orderId, String responseId) {
        return messages.create(403, new Object[]{orderId, responseId});
    }

    public static Message failedToProcessOrderResponse(String responseId, Party supplier, Party stockLocation, String reason) {
        return messages.create(500, new Object[]{responseId, supplier.getId(), supplier.getName(), stockLocation.getId(), stockLocation.getName(), reason});
    }

    public static Message invoiceNoProduct(String invoiceLineId) {
        return messages.create(601, new Object[]{invoiceLineId});
    }

    public static Message invoiceInvalidPayableAmount(String invoiceId, BigDecimal payableAmount, BigDecimal calculated) {
        return messages.create(602, new Object[]{invoiceId, payableAmount, calculated});
    }

    public static Message invoiceInvalidLineExtensionAmount(String invoiceId, BigDecimal lineExtensionAmount, BigDecimal calculated) {
        return messages.create(603, new Object[]{invoiceId, lineExtensionAmount, calculated});
    }

    public static Message invoiceInvalidTax(String invoiceId, BigDecimal tax, BigDecimal calculated) {
        return messages.create(604, new Object[]{invoiceId, tax, calculated});
    }

    public static Message invoiceLineInvalidLineExtensionAmount(String invoiceLineId, BigDecimal lineExtensionAmount, BigDecimal calculated) {
        return messages.create(605, new Object[]{invoiceLineId, lineExtensionAmount, calculated});
    }

    public static Message invoiceInvalidOrderItem(String invoiceLineId, String orderId) {
        return messages.create(606, new Object[]{invoiceLineId, orderId});
    }

    public static Message invoiceAllowanceNotSupported(String invoiceId) {
        return messages.create(607, new Object[]{invoiceId});
    }

    public static Message invoiceInvalidChargeTotal(String invoiceId, BigDecimal chargeTotalAmount, BigDecimal calculated) {
        return messages.create(608, new Object[]{invoiceId, chargeTotalAmount, calculated});
    }

    public static Message duplicateInvoice(String invoiceId, long deliveryId) {
        return messages.create(609, new Object[]{invoiceId, deliveryId});
    }

    public static Message duplicateInvoiceForOrder(String invoiceId, long orderId) {
        return messages.create(610, new Object[]{invoiceId, orderId});
    }

    public static Message invoiceInvalidTaxExclusiveAmount(String invoiceId, BigDecimal taxExclusiveAmount, BigDecimal calculated) {
        return messages.create(611, new Object[]{invoiceId, taxExclusiveAmount, calculated});
    }

    public static Message failedToProcessInvoice(String invoiceId, Party supplier, Party stockLocation, String reason) {
        return messages.create(700, new Object[]{invoiceId, supplier.getId(), supplier.getName(), stockLocation.getId(), stockLocation.getName(), reason});
    }

    public static Message unsupportedDocument(Party supplier, DocumentReferenceType reference, Object content) {
        String id = reference.getID() != null ? reference.getID().getValue() : null;
        String docType = reference.getDocumentType() != null ? reference.getDocumentType().getValue() : null;
        String clazz = content != null ? content.getClass().getName() : null;
        return messages.create(800, new Object[]{supplier.getId(), supplier.getName(), id, docType, clazz});
    }

    public static Message documentNotFound(Party supplier, DocumentReferenceType reference) {
        String id = reference.getID() != null ? reference.getID().getValue() : null;
        String docType = reference.getDocumentType() != null ? reference.getDocumentType().getValue() : null;
        return messages.create(801, new Object[]{supplier.getId(), supplier.getName(), id, docType});
    }

    public static Message failedToAcknowledgeDocument(Party supplier, DocumentReferenceType reference) {
        String id = reference.getID() != null ? reference.getID().getValue() : null;
        String docType = reference.getDocumentType() != null ? reference.getDocumentType().getValue() : null;
        return messages.create(802, new Object[]{supplier.getId(), supplier.getName(), id, docType});
    }

    public static Message orderInvoiced() {
        return messages.create(900, new Object[0]);
    }

    public static Message invoiceProcessedWithWarnings(List<String> warnings) {
        String bullet = "\n * ";
        return messages.create(901, new Object[]{warnings.size(), bullet + String.join((CharSequence)bullet, warnings)});
    }

    public static Message failedToProcessInbox(Party supplier, Party stockLocation, String reason) {
        return messages.create(1000, new Object[]{supplier.getId(), supplier.getName(), stockLocation.getId(), stockLocation.getName(), reason});
    }
}

