/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.dispatcher;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Tuple;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.dispatcher.ESCIConfig;

class ESCISuppliers {
    private final ArchetypeService service;

    public ESCISuppliers(ArchetypeService service) {
        this.service = service;
    }

    public List<ESCIConfig> getESCIConfigs() {
        ArrayList<ESCIConfig> result = new ArrayList<ESCIConfig>();
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Tuple.class).distinct(true);
        Root from = query.from(Party.class, new String[]{"party.supplierorganisation"}).alias("supplier");
        Join stockLocations = from.join("stockLocations", "entityRelationship.supplierStockLocationESCI").alias("stockLocation");
        Join location = stockLocations.join("target").alias("location");
        query.multiselect(new Selection[]{from, stockLocations, location});
        query.where(new Predicate[]{builder.equal((Expression)from.get("active"), (Object)true), builder.equal((Expression)location.get("active"), (Object)true)});
        TypedQuery typedQuery = this.service.createQuery(query);
        for (Tuple tuple : typedQuery.getResultList()) {
            EntityRelationship relationship = (EntityRelationship)tuple.get("stockLocation", EntityRelationship.class);
            if (!relationship.isActive()) continue;
            Party supplier = (Party)tuple.get("supplier", Party.class);
            Party stockLocation = (Party)tuple.get("location", Party.class);
            ESCIConfig config = new ESCIConfig(relationship, supplier, stockLocation, this.service);
            result.add(config);
        }
        return result;
    }
}

