/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.dispatcher;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSystemMessageFactory {
    private final ArchetypeService service;
    private static final Logger log = LoggerFactory.getLogger(AbstractSystemMessageFactory.class);

    protected AbstractSystemMessageFactory(ArchetypeService service) {
        this.service = service;
    }

    protected Act createMessage(Act act, String subject, String reason, String message) {
        Act result = null;
        User user = this.getAddressee(act);
        if (user != null) {
            result = (Act)this.service.create("act.systemMessage", Act.class);
            IMObjectBean bean = this.service.getBean((IMObject)result);
            bean.addTarget("item", (IMObject)act);
            bean.setTarget("to", (IMObject)user);
            bean.setValue("description", (Object)subject);
            bean.setValue("reason", (Object)reason);
            if (message != null) {
                message = StringUtils.abbreviate((String)message, (int)bean.getMaxLength("message"));
                bean.setValue("message", (Object)message);
            }
            bean.save();
        } else {
            log.error("Cannot create system message for {}:{}, subject=\"{}\", reason=\"{}\" message=\"{}\". No user found to address the message to.", new Object[]{act.getArchetype(), act.getId(), subject, reason, message});
        }
        return result;
    }

    protected User getAddressee(Act act) {
        Entity stockLocation;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        User result = null;
        if (act.getCreatedBy() != null) {
            result = (User)this.service.get(act.getCreatedBy(), User.class);
        }
        if (result == null && bean.hasNode("stockLocation") && (stockLocation = (Entity)bean.getTarget("stockLocation", Entity.class)) != null) {
            IMObjectBean locBean = this.service.getBean((IMObject)stockLocation);
            result = (User)locBean.getTarget("defaultAuthor", User.class);
        }
        return result;
    }

    protected ArchetypeService getService() {
        return this.service;
    }
}

