/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.client.impl;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.client.OrderServiceAdapter;
import org.openvpms.esci.adapter.client.SupplierServiceLocator;
import org.openvpms.esci.adapter.dispatcher.ESCIConfig;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.order.OrderMapper;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.service.OrderService;
import org.openvpms.esci.service.exception.DuplicateOrderException;
import org.openvpms.esci.ubl.order.Order;

public class OrderServiceAdapterImpl
implements OrderServiceAdapter {
    private final OrderMapper mapper;
    private final SupplierServiceLocator locator;
    private final IArchetypeService service;

    public OrderServiceAdapterImpl(OrderMapper mapper, SupplierServiceLocator locator, IArchetypeService service) {
        this.mapper = mapper;
        this.locator = locator;
        this.service = service;
    }

    @Override
    public void submitOrder(FinancialAct order) {
        IMObjectBean bean = this.service.getBean((IMObject)order);
        Party supplier = (Party)bean.getTarget("supplier", Party.class);
        if (supplier == null) {
            throw new IllegalStateException("Argument 'order' has no supplier participant");
        }
        Party stockLocation = (Party)bean.getTarget("stockLocation", Party.class);
        if (stockLocation == null) {
            throw new IllegalStateException("Argument 'order' has no stock location participant");
        }
        ESCIConfig config = ESCIConfig.create(supplier, stockLocation, (ArchetypeService)this.service);
        if (config == null) {
            throw new ESCIAdapterException(ESCIAdapterMessages.ESCINotConfigured(supplier, supplier));
        }
        OrderService orderService = this.locator.getOrderService(config);
        Order mapped = this.mapper.map(order);
        try {
            orderService.submitOrder(mapped);
        }
        catch (DuplicateOrderException exception) {
            throw new ESCIAdapterException(ESCIAdapterMessages.duplicateOrder(order.getId(), supplier), exception);
        }
    }
}

