/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.order;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.UBLDocument;
import org.openvpms.esci.adapter.map.UBLType;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.common.IdentifierType;
import org.openvpms.esci.ubl.common.aggregate.OrderReferenceType;
import org.openvpms.esci.ubl.common.basic.AcceptedIndicatorType;
import org.openvpms.esci.ubl.common.basic.RejectionNoteType;
import org.openvpms.esci.ubl.order.OrderResponseSimpleType;

public class UBLOrderResponseSimple
extends UBLType
implements UBLDocument {
    private final OrderResponseSimpleType response;
    private static final String SELLER_SUPPLIER_PARTY_PATH = "SellerSupplierParty";
    private static final String BUYER_CUSTOMER_PARTY_PATH = "BuyerCustomerParty";

    public UBLOrderResponseSimple(OrderResponseSimpleType response, ArchetypeService service) {
        super(null, service);
        this.response = response;
    }

    @Override
    public String getType() {
        return "OrderResponseSimple";
    }

    @Override
    public String getID() {
        return this.getId((IdentifierType)this.response.getID());
    }

    @Override
    public String getUBLVersionID() {
        return this.getId((IdentifierType)this.response.getUBLVersionID(), "UBLVersionID");
    }

    public boolean isAccepted() {
        AcceptedIndicatorType indicator = this.getRequired(this.response.getAcceptedIndicator(), "AcceptedIndicator");
        return indicator.isValue();
    }

    public String getRejectionNote() {
        String result = null;
        RejectionNoteType note = this.response.getRejectionNote();
        if (note != null && !StringUtils.isEmpty((CharSequence)note.getValue())) {
            result = note.getValue();
        }
        return result;
    }

    public FinancialAct getOrder() {
        OrderReferenceType reference = this.getRequired(this.response.getOrderReference(), "OrderReference");
        FinancialAct result = (FinancialAct)this.getObject("act.supplierOrder", (IdentifierType)reference.getID(), "OrderReference");
        if (result == null) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invalidOrder(this.getType(), this.getID(), reference.getID().getValue()));
        }
        return result;
    }

    public Party getSupplier() {
        return this.getSupplier(this.response.getSellerSupplierParty(), SELLER_SUPPLIER_PARTY_PATH);
    }

    public String getSupplierId() {
        return this.getSupplierId(this.response.getSellerSupplierParty(), SELLER_SUPPLIER_PARTY_PATH);
    }

    public void checkSupplier(Party expectedSupplier, String expectedAccountId) {
        Party supplier = this.getSupplier();
        String accountId = this.getSupplierId();
        this.checkSupplier(expectedSupplier, expectedAccountId, supplier, accountId, SELLER_SUPPLIER_PARTY_PATH);
    }

    public Party getStockLocation() {
        return this.getStockLocation(this.response.getBuyerCustomerParty(), BUYER_CUSTOMER_PARTY_PATH);
    }

    public String getStockLocationId() {
        return this.getStockLocationId(this.response.getBuyerCustomerParty(), BUYER_CUSTOMER_PARTY_PATH);
    }

    public void checkStockLocation(Party expectedStockLocation, String expectedAccountId) {
        Party stockLocation = this.getStockLocation();
        String accountId = this.getStockLocationId();
        this.checkStockLocation(expectedStockLocation, expectedAccountId, stockLocation, accountId, BUYER_CUSTOMER_PARTY_PATH);
    }
}

