/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.invoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.map.AbstractUBLMapper;
import org.openvpms.esci.adapter.map.invoice.InvoiceLineState;
import org.openvpms.esci.adapter.map.invoice.MappingContext;
import org.openvpms.esci.adapter.map.invoice.OrderItem;
import org.openvpms.esci.adapter.map.invoice.OrderResolver;
import org.openvpms.esci.adapter.map.invoice.UBLInvoice;
import org.openvpms.esci.adapter.map.invoice.UBLInvoiceLine;

class InvoiceOrderMatcher
extends AbstractUBLMapper {
    private final OrderResolver orderResolver;

    InvoiceOrderMatcher(ArchetypeService service, OrderResolver orderResolver) {
        super(service);
        this.orderResolver = orderResolver;
    }

    public MappingContext match(UBLInvoice invoice, Party supplier, Party stockLocation) {
        FinancialAct order = this.orderResolver.getOrder(invoice, supplier, stockLocation);
        MappingContext context = new MappingContext(invoice, supplier, stockLocation, order, this.getService());
        if (order != null) {
            context.addOrderItems(order);
        }
        ArrayList<InvoiceLineState> lines = new ArrayList<InvoiceLineState>();
        ArrayList<InvoiceLineState> unlinked = new ArrayList<InvoiceLineState>();
        for (UBLInvoiceLine uBLInvoiceLine : invoice.getInvoiceLines()) {
            InvoiceLineState state = this.getState(uBLInvoiceLine, context);
            lines.add(state);
            if (!state.isUnlinked()) continue;
            unlinked.add(state);
        }
        if (!unlinked.isEmpty()) {
            UnlinkedTracker tracker = new UnlinkedTracker(context);
            for (InvoiceLineState line : unlinked) {
                this.exactMatch(line, tracker);
            }
            HashSet<InvoiceLineState> hashSet = new HashSet<InvoiceLineState>(tracker.getPartialMatches());
            for (InvoiceLineState line : hashSet) {
                this.partialMatch(line, tracker);
            }
        }
        context.setInvoiceLines(lines);
        return context;
    }

    protected InvoiceLineState getState(UBLInvoiceLine line, MappingContext context) {
        OrderItem orderItem = this.orderResolver.getOrderItem(line, context);
        Product product = line.getProduct(context.getSupplier());
        FinancialAct order = orderItem != null ? orderItem.getOrder() : null;
        FinancialAct item = orderItem != null ? orderItem.getItem() : null;
        return new InvoiceLineState(line, product, order, item);
    }

    private void exactMatch(InvoiceLineState line, UnlinkedTracker unlinked) {
        FinancialAct result = null;
        Reference invoiceRef = line.getProduct().getObjectReference();
        ArchetypeService service = this.getService();
        for (FinancialAct item : unlinked.getItems(line.getOrder())) {
            IMObjectBean bean = service.getBean((IMObject)item);
            Reference orderRef = bean.getTargetRef("product");
            if (!Objects.equals(invoiceRef, orderRef)) continue;
            BigDecimal orderQuantity = item.getQuantity();
            if (line.getQuantity().compareTo(orderQuantity) == 0) {
                result = item;
                break;
            }
            unlinked.addPartialMatch(line, item);
        }
        if (result != null) {
            line.setOrderItem(result);
            unlinked.remove(line);
        }
    }

    private void partialMatch(InvoiceLineState line, UnlinkedTracker unlinked) {
        List<FinancialAct> matches = unlinked.getPartialMatches(line);
        if (!matches.isEmpty()) {
            if (matches.size() > 1) {
                matches.sort(Comparator.comparing(FinancialAct::getQuantity));
            }
            line.setOrderItem(matches.get(0));
            unlinked.remove(line);
        }
    }

    private static class UnlinkedTracker {
        private final Map<FinancialAct, List<FinancialAct>> unlinked;
        private final Map<InvoiceLineState, List<FinancialAct>> partial = new HashMap<InvoiceLineState, List<FinancialAct>>();

        UnlinkedTracker(MappingContext context) {
            this.unlinked = new HashMap<FinancialAct, List<FinancialAct>>(context.getOrderItems());
        }

        public List<FinancialAct> getItems(FinancialAct order) {
            List<FinancialAct> result = this.unlinked.get(order);
            return result != null ? result : Collections.emptyList();
        }

        public void remove(InvoiceLineState line) {
            List<FinancialAct> items = this.unlinked.get(line.getOrder());
            FinancialAct item = line.getOrderItem();
            if (items != null) {
                items.remove(item);
            }
            this.partial.remove(line);
            for (InvoiceLineState l : this.getPartialMatches()) {
                List<FinancialAct> matches = this.getPartialMatches(l);
                if (matches.isEmpty()) continue;
                matches.remove(item);
            }
        }

        public void addPartialMatch(InvoiceLineState line, FinancialAct item) {
            List items = this.partial.computeIfAbsent(line, k -> new ArrayList());
            items.add(item);
        }

        public Set<InvoiceLineState> getPartialMatches() {
            return this.partial.keySet();
        }

        public List<FinancialAct> getPartialMatches(InvoiceLineState line) {
            List<FinancialAct> result = this.partial.get(line);
            return result != null ? result : Collections.emptyList();
        }
    }
}

