/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map;

import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.ErrorContext;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.common.IdentifierType;
import org.openvpms.esci.ubl.common.aggregate.CustomerPartyType;
import org.openvpms.esci.ubl.common.aggregate.SupplierPartyType;
import org.openvpms.esci.ubl.common.basic.AdditionalAccountIDType;
import org.openvpms.esci.ubl.common.basic.CustomerAssignedAccountIDType;
import org.openvpms.esci.ubl.common.basic.SupplierAssignedAccountIDType;

public abstract class UBLType {
    private final UBLType parent;
    private final ArchetypeService service;
    private static final String CUSTOMER_ASSIGNED_ACCOUNT_ID_PATH = "/CustomerAssignedAccountID";

    protected UBLType(UBLType parent, ArchetypeService service) {
        this.parent = parent;
        this.service = service;
    }

    public abstract String getType();

    public abstract String getID();

    public String getMandatoryID() {
        String id = this.getID();
        return this.getRequired(id, "ID");
    }

    public String getPath() {
        return this.getType();
    }

    public UBLType getParent() {
        return this.parent;
    }

    public boolean useForErrorReporting() {
        return false;
    }

    public IMObject getObject(String archetype, IdentifierType id, String path) {
        Reference ref = this.getReference(archetype, id, path);
        return this.service.get(ref);
    }

    protected ArchetypeService getArchetypeService() {
        return this.service;
    }

    protected <T> T getRequired(T element, String path) {
        this.checkRequired(element, path);
        return element;
    }

    protected <T> void checkRequired(T element, String path) {
        if (element == null) {
            ErrorContext context = new ErrorContext(this, path);
            String id = context.getID();
            if (id != null) {
                throw new ESCIAdapterException(ESCIAdapterMessages.ublElementRequired(context.getPath(), context.getType(), id));
            }
            throw new ESCIAdapterException(ESCIAdapterMessages.ublElementRequired(context.getPath(), context.getType()));
        }
    }

    protected long getNumericId(IdentifierType id, String path) {
        String value = this.getId(id, path);
        long result = NumberUtils.toLong((String)value, (long)-2L);
        if (result == -2L) {
            ErrorContext context = new ErrorContext(this, path);
            throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidIdentifier(context.getPath(), context.getType(), context.getID(), id.getValue()));
        }
        return result;
    }

    protected String getId(IdentifierType id, String path) {
        String result = this.getId(id);
        this.checkRequired(result, path);
        return result;
    }

    protected String getId(IdentifierType id) {
        String result = null;
        if (id != null) {
            result = StringUtils.trimToNull((String)id.getValue());
        }
        return result;
    }

    protected Party getSupplier(SupplierPartyType supplierType, String path) {
        this.checkRequired(supplierType, path);
        CustomerAssignedAccountIDType accountId = supplierType.getCustomerAssignedAccountID();
        Party supplier = null;
        if (accountId != null) {
            long id = this.getNumericId((IdentifierType)accountId, path + CUSTOMER_ASSIGNED_ACCOUNT_ID_PATH);
            supplier = this.getObject(id, Party.class, "party.supplier*");
            if (supplier == null) {
                ErrorContext context = new ErrorContext(this, path + CUSTOMER_ASSIGNED_ACCOUNT_ID_PATH);
                throw new ESCIAdapterException(ESCIAdapterMessages.invalidSupplier(context.getPath(), context.getType(), context.getID(), accountId.getValue()));
            }
        }
        return supplier;
    }

    protected String getSupplierId(SupplierPartyType supplierType, String path) {
        this.checkRequired(supplierType, path);
        return this.getAdditionalAccountId(supplierType.getAdditionalAccountID(), path + "/AdditionalAccountID");
    }

    protected void checkSupplier(Party expectedSupplier, String expectedAccountId, Party supplier, String accountId, String path) {
        if (supplier == null && accountId == null) {
            ErrorContext context = new ErrorContext(this, path);
            throw new ESCIAdapterException(ESCIAdapterMessages.noCustomerOrAdditionalAccountId(context.getPath(), context.getType(), context.getID()));
        }
        if (supplier != null && !expectedSupplier.equals(supplier)) {
            ErrorContext context = new ErrorContext(this, path + CUSTOMER_ASSIGNED_ACCOUNT_ID_PATH);
            throw new ESCIAdapterException(ESCIAdapterMessages.supplierMismatch(context.getPath(), context.getType(), context.getID(), expectedSupplier, supplier));
        }
        if (accountId != null && !accountId.equals(expectedAccountId)) {
            ErrorContext context = new ErrorContext(this, path + "/AdditionalAccountID");
            throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue(context.getPath(), context.getType(), context.getID(), expectedAccountId, accountId));
        }
    }

    protected Party getStockLocation(CustomerPartyType customerType, String path) {
        String idPath;
        this.checkRequired(customerType, path);
        CustomerAssignedAccountIDType accountId = customerType.getCustomerAssignedAccountID();
        Party location = null;
        if (accountId != null && (location = (Party)this.getObject("party.organisationStockLocation", (IdentifierType)accountId, idPath = path + CUSTOMER_ASSIGNED_ACCOUNT_ID_PATH)) == null) {
            ErrorContext context = new ErrorContext(this, idPath);
            throw new ESCIAdapterException(ESCIAdapterMessages.invalidStockLocation(context.getPath(), context.getType(), context.getID(), accountId.getValue()));
        }
        return location;
    }

    protected String getStockLocationId(CustomerPartyType customerType, String path) {
        this.checkRequired(customerType, path);
        SupplierAssignedAccountIDType accountId = customerType.getSupplierAssignedAccountID();
        return accountId != null ? this.getId((IdentifierType)accountId, path + "/SupplierAssignedAccountID") : null;
    }

    protected void checkStockLocation(Party expectedStockLocation, String expectedAccountId, Party stockLocation, String accountId, String path) {
        if (stockLocation == null && accountId == null) {
            ErrorContext context = new ErrorContext(this, path);
            throw new ESCIAdapterException(ESCIAdapterMessages.noCustomerOrSupplierAccountId(context.getPath(), context.getType(), context.getID()));
        }
        if (stockLocation != null && !expectedStockLocation.equals(stockLocation)) {
            ErrorContext context = new ErrorContext(this, path + CUSTOMER_ASSIGNED_ACCOUNT_ID_PATH);
            throw new ESCIAdapterException(ESCIAdapterMessages.stockLocationMismatch(context.getPath(), context.getType(), context.getID(), expectedStockLocation, stockLocation));
        }
        if (accountId != null && !accountId.equals(expectedAccountId)) {
            ErrorContext context = new ErrorContext(this, path + "/SupplierAssignedAccountID");
            throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue(context.getPath(), context.getType(), context.getID(), expectedAccountId, accountId));
        }
    }

    protected String getAdditionalAccountId(List<AdditionalAccountIDType> ids, String path) {
        String result = null;
        if (!ids.isEmpty()) {
            if (ids.size() != 1) {
                ErrorContext context = new ErrorContext(this, path);
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidCardinality(context.getPath(), context.getType(), context.getID(), "1", ids.size()));
            }
            result = this.getId((IdentifierType)ids.get(0), path);
        }
        return result;
    }

    protected <T extends IMObject> T getObject(long id, Class<T> type, String ... archetypes) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(type);
        Root root = query.from(type, archetypes);
        query.where(new Predicate[]{builder.equal((Expression)root.get("id"), (Object)id), builder.equal((Expression)root.get("active"), (Object)true)});
        return (T)((IMObject)this.service.createQuery(query).getFirstResult());
    }

    protected Reference getReference(String archetype, IdentifierType id, String path) {
        long objectId = this.getNumericId(id, path);
        return new IMObjectReference(archetype, objectId);
    }
}

