/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openvpms.archetype.rules.math.Currencies;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.common.AmountType;
import org.openvpms.esci.ubl.common.CodeType;
import org.openvpms.esci.ubl.common.CurrencyCodeContentType;
import org.openvpms.esci.ubl.common.IdentifierType;
import org.openvpms.esci.ubl.common.NameType;
import org.openvpms.esci.ubl.common.QuantityType;
import org.openvpms.esci.ubl.common.TextType;
import org.openvpms.esci.ubl.common.aggregate.OrderLineReferenceType;
import org.openvpms.esci.ubl.common.aggregate.OrderReferenceType;
import org.openvpms.esci.ubl.common.basic.IDType;
import org.openvpms.esci.ubl.common.basic.IssueDateType;
import org.openvpms.esci.ubl.common.basic.IssueTimeType;
import org.openvpms.esci.ubl.common.basic.LineIDType;
import org.openvpms.esci.ubl.common.basic.PackSizeNumericType;
import org.openvpms.esci.ubl.common.basic.PercentType;

public class UBLHelper {
    private UBLHelper() {
    }

    public static Currency getCurrency(PracticeRules rules, Currencies currencies, ArchetypeService service) {
        Party practice = rules.getPractice();
        if (practice == null) {
            throw new IllegalStateException("No party.organisationPractice defined");
        }
        IMObjectBean bean = service.getBean((IMObject)practice);
        String code = bean.getString("currency");
        return currencies.getCurrency(code);
    }

    public static IDType createID(String id) {
        IDType result = new IDType();
        result.setValue(id);
        return result;
    }

    public static IDType createID(long id) {
        IDType result = new IDType();
        return UBLHelper.initID(result, id);
    }

    public static <T extends IdentifierType> T initID(T id, String value) {
        id.setValue(value);
        return id;
    }

    public static <T extends IdentifierType> T initID(T id, long value) {
        return UBLHelper.initID(id, Long.toString(value));
    }

    public static <T extends TextType> T initText(T text, String value) {
        text.setValue(value);
        return text;
    }

    public static org.openvpms.esci.ubl.common.basic.NameType createName(String name) {
        org.openvpms.esci.ubl.common.basic.NameType result = new org.openvpms.esci.ubl.common.basic.NameType();
        result.setValue(name);
        return result;
    }

    public static <T extends NameType> T initName(T name, String value) {
        name.setValue(value);
        return name;
    }

    public static <T extends AmountType> T initAmount(T amount, BigDecimal value, Currency currency) {
        CurrencyCodeContentType code = CurrencyCodeContentType.valueOf((String)currency.getCode());
        BigDecimal rounded = currency.round(value);
        if (rounded.compareTo(value) != 0) {
            throw new ESCIAdapterException(ESCIAdapterMessages.amountTooManyDecimalPlaces(value));
        }
        amount.setCurrencyID(code);
        amount.setValue(rounded);
        return amount;
    }

    public static <T extends QuantityType> T initQuantity(T quantity, BigDecimal value, String unitCode) {
        BigDecimal rounded = MathRules.round((BigDecimal)value, (int)2);
        if (rounded.compareTo(value) != 0) {
            throw new ESCIAdapterException(ESCIAdapterMessages.quantityTooManyDecimalPlaces(value));
        }
        quantity.setValue(rounded);
        quantity.setUnitCode(unitCode);
        return quantity;
    }

    public static PercentType createPercent(BigDecimal value) {
        PercentType result = new PercentType();
        result.setValue(value);
        return result;
    }

    public static PackSizeNumericType createPackSizeNumeric(BigDecimal value) {
        PackSizeNumericType result = new PackSizeNumericType();
        result.setValue(value);
        return result;
    }

    public static IssueDateType createIssueDate(Date date, DatatypeFactory factory) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return UBLHelper.createIssueDate(calendar, factory);
    }

    public static IssueDateType createIssueDate(GregorianCalendar calendar, DatatypeFactory factory) {
        IssueDateType result = new IssueDateType();
        result.setValue(UBLHelper.getDate(calendar, factory));
        return result;
    }

    public static IssueTimeType createIssueTime(Date date, DatatypeFactory factory) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return UBLHelper.createIssueTime(calendar, factory);
    }

    public static IssueTimeType createIssueTime(GregorianCalendar calendar, DatatypeFactory factory) {
        IssueTimeType result = new IssueTimeType();
        result.setValue(UBLHelper.getTime(calendar, factory));
        return result;
    }

    public static OrderReferenceType createOrderReference(long id) {
        OrderReferenceType result = new OrderReferenceType();
        result.setID(UBLHelper.createID(id));
        return result;
    }

    public static OrderLineReferenceType createOrderLineReference(long id) {
        return UBLHelper.createOrderLineReference(id, null);
    }

    public static OrderLineReferenceType createOrderLineReference(long id, OrderReferenceType order) {
        OrderLineReferenceType result = new OrderLineReferenceType();
        result.setLineID(UBLHelper.initID(new LineIDType(), id));
        result.setOrderReference(order);
        return result;
    }

    public static <T extends CodeType> T initCode(T code, String value) {
        code.setValue(value);
        return code;
    }

    private static XMLGregorianCalendar getDate(GregorianCalendar calendar, DatatypeFactory factory) {
        XMLGregorianCalendar xml = factory.newXMLGregorianCalendar(calendar);
        xml.setHour(Integer.MIN_VALUE);
        xml.setMinute(Integer.MIN_VALUE);
        xml.setSecond(Integer.MIN_VALUE);
        xml.setMillisecond(Integer.MIN_VALUE);
        xml.setTimezone(Integer.MIN_VALUE);
        return xml;
    }

    private static XMLGregorianCalendar getTime(GregorianCalendar calendar, DatatypeFactory factory) {
        XMLGregorianCalendar xml = factory.newXMLGregorianCalendar(calendar);
        xml.setDay(Integer.MIN_VALUE);
        xml.setMonth(Integer.MIN_VALUE);
        xml.setYear(Integer.MIN_VALUE);
        xml.setTimezone(Integer.MIN_VALUE);
        return xml;
    }
}

