/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.dispatcher.order;

import org.openvpms.component.i18n.Message;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.dispatcher.DocumentProcessor;
import org.openvpms.esci.adapter.dispatcher.InboxDocument;
import org.openvpms.esci.adapter.dispatcher.ProcessingConfig;
import org.openvpms.esci.adapter.dispatcher.order.OrderResponseListener;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.order.DuplicateOrderResponseException;
import org.openvpms.esci.adapter.map.order.OrderResponseMapper;
import org.openvpms.esci.adapter.map.order.OrderResponseMapperImpl;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.order.OrderResponseSimpleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderResponseProcessor
implements DocumentProcessor {
    private final OrderResponseMapper mapper;
    private final OrderResponseListener listener;
    private final ArchetypeService service;
    private static final Logger log = LoggerFactory.getLogger(OrderResponseProcessor.class);

    public OrderResponseProcessor(OrderResponseListener listener, ArchetypeService service) {
        this.mapper = new OrderResponseMapperImpl(service);
        this.listener = listener;
        this.service = service;
    }

    @Override
    public boolean canHandle(InboxDocument document) {
        return document.getContent() instanceof OrderResponseSimpleType;
    }

    @Override
    public void process(InboxDocument document, Party supplier, Party stockLocation, String accountId, ProcessingConfig config) {
        OrderResponseSimpleType response = (OrderResponseSimpleType)document.getContent();
        try {
            FinancialAct order = this.mapper.map(response, supplier, stockLocation, accountId);
            this.service.save((IMObject)order);
            this.notifyListener(order);
        }
        catch (DuplicateOrderResponseException exception) {
            log.warn("Skipping {}", (Object)exception.getMessage());
        }
        catch (Exception exception) {
            String responseId = response.getID() != null ? response.getID().getValue() : null;
            Message message = ESCIAdapterMessages.failedToProcessOrderResponse(responseId, supplier, stockLocation, exception.getMessage());
            throw new ESCIAdapterException(message, exception);
        }
    }

    protected void notifyListener(FinancialAct order) {
        OrderResponseListener l = this.listener;
        if (l != null) {
            try {
                l.receivedResponse(order);
            }
            catch (Exception exception) {
                log.error("OrderResponseListener threw exception", (Throwable)exception);
            }
        }
    }
}

