/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2025 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.esci.adapter.map.invoice;

import org.openvpms.component.i18n.Message;
import org.openvpms.esci.adapter.util.ESCIAdapterException;

/**
 * Exception for when an invoice is a duplicate.
 *
 * @author Tim Anderson
 */
public class DuplicateInvoiceException extends ESCIAdapterException {

    /**
     * Constructs an {@link DuplicateInvoiceException}.
     *
     * @param message the message
     */
    public DuplicateInvoiceException(Message message) {
        super(message);
    }
}