/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.invoice;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.esci.adapter.i18n.ESCIAdapterMessages;
import org.openvpms.esci.adapter.map.ErrorContext;
import org.openvpms.esci.adapter.map.UBLFinancialType;
import org.openvpms.esci.adapter.map.invoice.UBLInvoice;
import org.openvpms.esci.adapter.map.invoice.UBLTaxSubtotal;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.common.AmountType;
import org.openvpms.esci.ubl.common.IdentifierType;
import org.openvpms.esci.ubl.common.QuantityType;
import org.openvpms.esci.ubl.common.aggregate.InvoiceLineType;
import org.openvpms.esci.ubl.common.aggregate.ItemIdentificationType;
import org.openvpms.esci.ubl.common.aggregate.ItemType;
import org.openvpms.esci.ubl.common.aggregate.OrderLineReferenceType;
import org.openvpms.esci.ubl.common.aggregate.OrderReferenceType;
import org.openvpms.esci.ubl.common.aggregate.PriceType;
import org.openvpms.esci.ubl.common.aggregate.PricingReferenceType;
import org.openvpms.esci.ubl.common.basic.BaseQuantityType;
import org.openvpms.esci.ubl.common.basic.InvoicedQuantityType;
import org.openvpms.esci.ubl.common.basic.LineIDType;
import org.openvpms.esci.ubl.common.basic.PackQuantityType;
import org.openvpms.esci.ubl.common.basic.PackSizeNumericType;
import org.openvpms.esci.ubl.common.basic.PriceTypeCodeType;

public class UBLInvoiceLine
extends UBLFinancialType {
    private final InvoiceLineType line;
    private final SupplierRules supplierRules;
    private static final String WHOLESALE = "WH";
    private static final String ALTERNATIVE_CONDITION_PRICE = "PricingReference/AlternativeConditionPrice";
    private static final String ALTERNATIVE_CONDITION_PRICE_TYPE_CODE = "PricingReference/AlternativeConditionPrice/PriceTypeCode";

    public UBLInvoiceLine(InvoiceLineType line, UBLInvoice parent, String expectedCurrency, IArchetypeService service, SupplierRules rules) {
        super(parent, expectedCurrency, service);
        this.line = line;
        this.supplierRules = rules;
    }

    @Override
    public String getType() {
        return "InvoiceLine";
    }

    @Override
    public String getID() {
        return this.getId((IdentifierType)this.line.getID());
    }

    @Override
    public boolean useForErrorReporting() {
        return true;
    }

    public Reference getOrderReference() {
        OrderReferenceType orderRef;
        Reference result = null;
        OrderLineReferenceType orderLineRef = this.getOrderLineReference();
        if (orderLineRef != null && (orderRef = orderLineRef.getOrderReference()) != null) {
            result = this.getReference("act.supplierOrder", (IdentifierType)orderRef.getID(), "OrderLineReference/OrderReference");
        }
        return result;
    }

    public Reference getOrderItemReference() {
        Reference result = null;
        OrderLineReferenceType ref = this.getOrderLineReference();
        if (ref != null) {
            LineIDType id = ref.getLineID();
            result = this.getReference("act.supplierOrderItem", (IdentifierType)id, "OrderLineReference/LineID");
        }
        return result;
    }

    public OrderLineReferenceType getOrderLineReference() {
        OrderLineReferenceType result = null;
        List list = this.line.getOrderLineReference();
        if (!list.isEmpty()) {
            if (list.size() != 1) {
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidCardinality("OrderLineReference", this.getType(), this.getID(), "1", list.size()));
            }
            result = (OrderLineReferenceType)list.get(0);
        }
        return result;
    }

    public FinancialAct getOrder() {
        FinancialAct result = null;
        Reference ref = this.getOrderReference();
        if (ref != null && (result = (FinancialAct)this.getArchetypeService().get(ref)) == null) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invalidOrder(this.getType(), this.getID(), Long.toString(ref.getId())));
        }
        return result;
    }

    public FinancialAct getOrderItem() {
        FinancialAct result = null;
        Reference ref = this.getOrderItemReference();
        if (ref != null && ref.getId() != -1L && (result = (FinancialAct)this.getArchetypeService().get(ref)) == null) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invoiceInvalidOrderItem(this.getID(), Long.toString(ref.getId())));
        }
        return result;
    }

    public BigDecimal getLineExtensionAmount() {
        return this.getAmount((AmountType)this.line.getLineExtensionAmount(), "LineExtensionAmount");
    }

    public BigDecimal getInvoicedQuantity() {
        return this.getQuantity((QuantityType)this.line.getInvoicedQuantity(), "InvoicedQuantity");
    }

    public String getInvoicedQuantityUnitCode() {
        InvoicedQuantityType quantity = this.getRequired(this.line.getInvoicedQuantity(), "InvoicedQuantity");
        return this.getRequired(quantity.getUnitCode(), "InvoicedQuantity@unitCode");
    }

    public Product getProduct(Party supplier) {
        Product result = null;
        long productId = this.getBuyersItemID();
        String sellerId = this.getSellersItemID();
        if (productId == -1L && sellerId == null) {
            throw new ESCIAdapterException(ESCIAdapterMessages.invoiceNoProduct(this.getID()));
        }
        if (productId != -1L) {
            result = this.getProduct(productId);
        }
        if (result == null && sellerId != null) {
            result = this.getProduct(sellerId, supplier);
        }
        return result;
    }

    public long getBuyersItemID() {
        long result = -1L;
        ItemType item = this.getItem();
        ItemIdentificationType id = item.getBuyersItemIdentification();
        if (id != null) {
            result = this.getNumericId((IdentifierType)id.getID(), "Item/BuyersItemIdentification/ID");
        }
        return result;
    }

    public String getSellersItemID() {
        String result = null;
        ItemType item = this.getItem();
        ItemIdentificationType sellerId = item.getSellersItemIdentification();
        if (sellerId != null) {
            result = this.getId((IdentifierType)sellerId.getID(), "Item/SellersItemIdentification/ID");
        }
        return result;
    }

    public String getItemName() {
        ItemType item = this.getItem();
        return item.getName() != null ? StringUtils.trimToNull((String)item.getName().getValue()) : null;
    }

    public BigDecimal getPackSizeNumeric() {
        PackSizeNumericType packSize = this.getItem().getPackSizeNumeric();
        return packSize != null ? packSize.getValue() : BigDecimal.ZERO;
    }

    public BigDecimal getPackQuantity() {
        PackQuantityType quantity = this.getItem().getPackQuantity();
        return quantity != null ? quantity.getValue() : null;
    }

    public String getPackQuantityUnitCode() {
        PackQuantityType quantity = this.getItem().getPackQuantity();
        return quantity != null ? this.getRequired(quantity.getUnitCode(), "PackQuantity@unitCode") : null;
    }

    public BigDecimal getPriceAmount() {
        PriceType price = this.getRequired(this.line.getPrice(), "Price");
        return this.getAmount((AmountType)price.getPriceAmount(), "Price/PriceAmount");
    }

    public BigDecimal getWholesalePrice() {
        List prices;
        BigDecimal result = null;
        PricingReferenceType pricing = this.line.getPricingReference();
        if (pricing != null && !(prices = pricing.getAlternativeConditionPrice()).isEmpty()) {
            PriceType price = (PriceType)prices.get(0);
            result = this.getAmount((AmountType)price.getPriceAmount(), "PricingReference/AlternativeConditionPrice/PriceAmount");
            PriceTypeCodeType code = this.getRequired(price.getPriceTypeCode(), ALTERNATIVE_CONDITION_PRICE_TYPE_CODE);
            if (!WHOLESALE.equals(code.getValue())) {
                ErrorContext context = new ErrorContext(this, ALTERNATIVE_CONDITION_PRICE_TYPE_CODE);
                throw new ESCIAdapterException(ESCIAdapterMessages.ublInvalidValue(context.getPath(), context.getType(), context.getID(), WHOLESALE, code.getValue()));
            }
        }
        return result;
    }

    public BigDecimal getBaseQuantity() {
        BaseQuantityType quantity = this.line.getPrice().getBaseQuantity();
        return quantity != null ? quantity.getValue() : null;
    }

    public String getBaseQuantityUnitCode() {
        BaseQuantityType quantity = this.line.getPrice().getBaseQuantity();
        return quantity != null ? quantity.getUnitCode() : null;
    }

    public BigDecimal getTaxAmount() {
        return this.getTaxAmount(this.line.getTaxTotal());
    }

    public UBLTaxSubtotal getTaxSubtotal() {
        return this.getTaxSubtotal(this.line.getTaxTotal());
    }

    protected Product getProduct(long id) {
        return (Product)this.getObject(id, "product.medication", "product.merchandise", "product.service");
    }

    protected Product getProduct(String reorderCode, Party supplier) {
        Product result = null;
        List list = this.supplierRules.getProductSuppliers(supplier);
        for (ProductSupplier ps : list) {
            Product product;
            if (!StringUtils.equals((CharSequence)reorderCode, (CharSequence)ps.getReorderCode()) || (product = ps.getProduct()) == null || !product.isActive()) continue;
            result = product;
            break;
        }
        return result;
    }

    protected ItemType getItem() {
        return this.getRequired(this.line.getItem(), "Item");
    }
}

