/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.invoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.party.Party;
import org.openvpms.esci.adapter.map.UBLDocument;
import org.openvpms.esci.adapter.map.UBLFinancialType;
import org.openvpms.esci.adapter.map.invoice.UBLAllowanceCharge;
import org.openvpms.esci.adapter.map.invoice.UBLInvoiceLine;
import org.openvpms.esci.ubl.common.AmountType;
import org.openvpms.esci.ubl.common.IdentifierType;
import org.openvpms.esci.ubl.common.aggregate.AllowanceChargeType;
import org.openvpms.esci.ubl.common.aggregate.InvoiceLineType;
import org.openvpms.esci.ubl.common.aggregate.MonetaryTotalType;
import org.openvpms.esci.ubl.common.aggregate.OrderReferenceType;
import org.openvpms.esci.ubl.common.basic.ChargeTotalAmountType;
import org.openvpms.esci.ubl.common.basic.IssueDateType;
import org.openvpms.esci.ubl.common.basic.IssueTimeType;
import org.openvpms.esci.ubl.common.basic.NoteType;
import org.openvpms.esci.ubl.invoice.InvoiceType;

public class UBLInvoice
extends UBLFinancialType
implements UBLDocument {
    private final InvoiceType invoice;
    private final SupplierRules supplierRules;
    private static final String ACCOUNTING_SUPPLIER_PARTY_PATH = "AccountingSupplierParty";
    private static final String ACCOUNTING_CUSTOMER_PARTY_PATH = "AccountingCustomerParty";

    public UBLInvoice(InvoiceType invoice, String currency, IArchetypeService service, SupplierRules supplierRules) {
        super(null, currency, service);
        this.invoice = invoice;
        this.supplierRules = supplierRules;
    }

    @Override
    public String getType() {
        return "Invoice";
    }

    @Override
    public String getID() {
        return this.getId((IdentifierType)this.invoice.getID());
    }

    @Override
    public boolean useForErrorReporting() {
        return true;
    }

    @Override
    public String getUBLVersionID() {
        return this.getId((IdentifierType)this.invoice.getUBLVersionID(), "UBLVersionID");
    }

    public Date getIssueDatetime() {
        XMLGregorianCalendar time;
        IssueDateType issueDate = this.getRequired(this.invoice.getIssueDate(), "IssueDate");
        XMLGregorianCalendar calendar = issueDate.getValue();
        this.checkRequired(calendar, "IssueDate");
        IssueTimeType issueTime = this.invoice.getIssueTime();
        if (issueTime != null && (time = issueTime.getValue()) != null) {
            calendar.setHour(time.getHour());
            calendar.setMinute(time.getMinute());
            calendar.setSecond(time.getSecond());
            calendar.setMillisecond(time.getMillisecond());
        }
        return calendar.toGregorianCalendar().getTime();
    }

    public String getNotes() {
        String result = null;
        List notes = this.invoice.getNote();
        if (notes != null && !notes.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            for (NoteType note : notes) {
                if (buffer.length() != 0) {
                    buffer.append('\n');
                }
                if (StringUtils.isEmpty((CharSequence)note.getValue())) continue;
                buffer.append(note.getValue());
            }
            result = buffer.toString();
        }
        return result;
    }

    public Party getSupplier() {
        return this.getSupplier(this.invoice.getAccountingSupplierParty(), ACCOUNTING_SUPPLIER_PARTY_PATH);
    }

    public String getSupplierId() {
        return this.getSupplierId(this.invoice.getAccountingSupplierParty(), ACCOUNTING_SUPPLIER_PARTY_PATH);
    }

    public void checkSupplier(Party expectedSupplier, String expectedAccountId) {
        Party supplier = this.getSupplier();
        String accountId = this.getSupplierId();
        this.checkSupplier(expectedSupplier, expectedAccountId, supplier, accountId, ACCOUNTING_SUPPLIER_PARTY_PATH);
    }

    public Party getStockLocation() {
        return this.getStockLocation(this.invoice.getAccountingCustomerParty(), ACCOUNTING_CUSTOMER_PARTY_PATH);
    }

    public String getStockLocationId() {
        return this.getStockLocationId(this.invoice.getAccountingCustomerParty(), ACCOUNTING_CUSTOMER_PARTY_PATH);
    }

    public void checkStockLocation(Party expectedStockLocation, String expectedAccountId) {
        Party stockLocation = this.getStockLocation();
        String accountId = this.getStockLocationId();
        this.checkStockLocation(expectedStockLocation, expectedAccountId, stockLocation, accountId, ACCOUNTING_CUSTOMER_PARTY_PATH);
    }

    public OrderReferenceType getOrderReference() {
        return this.invoice.getOrderReference();
    }

    public BigDecimal getPayableAmount() {
        MonetaryTotalType monetaryTotal = this.getLegalMonetaryTotal();
        return this.getAmount((AmountType)monetaryTotal.getPayableAmount(), "LegalMonetaryTotal/PayableAmount");
    }

    public BigDecimal getLineExtensionAmount() {
        MonetaryTotalType monetaryTotal = this.getLegalMonetaryTotal();
        return this.getAmount((AmountType)monetaryTotal.getLineExtensionAmount(), "LegalMonetaryTotal/LineExtensionAmount");
    }

    public BigDecimal getChargeTotal() {
        BigDecimal result = BigDecimal.ZERO;
        MonetaryTotalType monetaryTotal = this.getLegalMonetaryTotal();
        ChargeTotalAmountType amount = monetaryTotal.getChargeTotalAmount();
        if (amount != null) {
            result = this.getAmount((AmountType)amount, "LegalMonetaryTotal/ChargeTotalAmount");
        }
        return result;
    }

    public BigDecimal getTaxExclusiveAmount() {
        MonetaryTotalType monetaryTotal = this.getLegalMonetaryTotal();
        return this.getAmount((AmountType)monetaryTotal.getTaxExclusiveAmount(), "LegalMonetaryTotal/TaxExclusiveAmount");
    }

    public BigDecimal getTaxAmount() {
        return this.getTaxAmount(this.invoice.getTaxTotal());
    }

    public List<UBLInvoiceLine> getInvoiceLines() {
        ArrayList<UBLInvoiceLine> result = new ArrayList<UBLInvoiceLine>(this.invoice.getInvoiceLine().size());
        for (InvoiceLineType line : this.invoice.getInvoiceLine()) {
            result.add(new UBLInvoiceLine(line, this, this.getCurrency(), this.getArchetypeService(), this.supplierRules));
        }
        return result;
    }

    public List<UBLAllowanceCharge> getAllowanceCharges() {
        ArrayList<UBLAllowanceCharge> result = new ArrayList<UBLAllowanceCharge>(this.invoice.getAllowanceCharge().size());
        for (AllowanceChargeType ac : this.invoice.getAllowanceCharge()) {
            result.add(new UBLAllowanceCharge(ac, this, this.getCurrency(), this.getArchetypeService()));
        }
        return result;
    }

    protected MonetaryTotalType getLegalMonetaryTotal() {
        return this.getRequired(this.invoice.getLegalMonetaryTotal(), "LegalMonetaryTotal");
    }
}

