/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.invoice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.map.invoice.InvoiceLineState;
import org.openvpms.esci.adapter.map.invoice.UBLInvoice;

class MappingContext {
    private final UBLInvoice invoice;
    private final Party supplier;
    private final Party stockLocation;
    private final ArchetypeService service;
    private FinancialAct docOrder;
    private Map<Reference, FinancialAct> orders = new HashMap<Reference, FinancialAct>();
    private Map<FinancialAct, List<FinancialAct>> items = new HashMap<FinancialAct, List<FinancialAct>>();
    private List<InvoiceLineState> lines;

    public MappingContext(UBLInvoice invoice, Party supplier, Party stockLocation, FinancialAct docOrder, ArchetypeService service) {
        this.invoice = invoice;
        this.supplier = supplier;
        this.stockLocation = stockLocation;
        this.docOrder = docOrder;
        this.service = service;
        if (docOrder != null) {
            this.addOrder(docOrder);
        }
    }

    public UBLInvoice getInvoice() {
        return this.invoice;
    }

    public Party getSupplier() {
        return this.supplier;
    }

    public Party getStockLocation() {
        return this.stockLocation;
    }

    public FinancialAct getDocumentOrder() {
        return this.docOrder;
    }

    public FinancialAct getOrder(Reference reference) {
        return this.orders.get(reference);
    }

    public List<FinancialAct> getOrders() {
        return new ArrayList<FinancialAct>(this.orders.values());
    }

    public void addOrder(FinancialAct order) {
        this.orders.put(order.getObjectReference(), order);
    }

    public void addOrderItems(FinancialAct order) {
        IMObjectBean bean = this.service.getBean((IMObject)order);
        List list = bean.getTargets("items", FinancialAct.class);
        this.items.put(order, list);
    }

    public Map<FinancialAct, List<FinancialAct>> getOrderItems() {
        return this.items;
    }

    public FinancialAct getOrderItem(FinancialAct order, Reference itemRef) {
        List<FinancialAct> list = this.items.get(order);
        if (list != null) {
            for (FinancialAct item : list) {
                if (item.getId() != itemRef.getId()) continue;
                return item;
            }
        }
        return null;
    }

    public void setInvoiceLines(List<InvoiceLineState> lines) {
        this.lines = lines;
    }

    public List<InvoiceLineState> getInvoiceLines() {
        return this.lines;
    }
}

