/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.esci.adapter.map.invoice;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.map.invoice.AbstractOrderResolver;
import org.openvpms.esci.adapter.map.invoice.MappingContext;
import org.openvpms.esci.adapter.map.invoice.OrderItem;
import org.openvpms.esci.adapter.map.invoice.UBLInvoice;
import org.openvpms.esci.adapter.map.invoice.UBLInvoiceLine;
import org.openvpms.esci.adapter.util.ESCIAdapterException;

public class LenientOrderResolver
extends AbstractOrderResolver {
    private List<ESCIAdapterException> errors = new ArrayList<ESCIAdapterException>();

    public LenientOrderResolver(ArchetypeService service) {
        super(service);
    }

    @Override
    public FinancialAct getOrder(UBLInvoice invoice, Party supplier, Party stockLocation) {
        FinancialAct order = null;
        try {
            order = super.getOrder(invoice, supplier, stockLocation);
        }
        catch (ESCIAdapterException exception) {
            this.errors.add(exception);
        }
        return order;
    }

    @Override
    public OrderItem getOrderItem(UBLInvoiceLine line, MappingContext context) {
        OrderItem result;
        try {
            result = super.getOrderItem(line, context);
        }
        catch (ESCIAdapterException exception) {
            this.errors.add(exception);
            result = null;
        }
        return result;
    }

    public List<ESCIAdapterException> getErrors() {
        return this.errors;
    }
}

