/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.eftpos.internal.transaction;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.eftpos.internal.event.EventMonitor;
import org.openvpms.eftpos.internal.transaction.PaymentImpl;
import org.openvpms.eftpos.internal.transaction.RefundImpl;
import org.openvpms.eftpos.transaction.Payment;
import org.openvpms.eftpos.transaction.Receipt;
import org.openvpms.eftpos.transaction.Refund;
import org.openvpms.eftpos.transaction.Transaction;
import org.openvpms.eftpos.transaction.Transactions;

public class TransactionsImpl
implements Transactions {
    private final ArchetypeService service;
    private final DomainService domainService;
    private final PracticeService practiceService;
    private final EventMonitor monitor;

    public TransactionsImpl(ArchetypeService service, DomainService domainService, PracticeService practiceService, EventMonitor monitor) {
        this.service = service;
        this.domainService = domainService;
        this.practiceService = practiceService;
        this.monitor = monitor;
    }

    public Payment getPayment(long id) {
        Act act = (Act)this.service.get("act.EFTPOSPayment", id, Act.class);
        return act != null ? new PaymentImpl(act, this.service, this.domainService, this.practiceService) : null;
    }

    public Payment getPayment(String archetype, String id) {
        Act act = this.getTransaction(archetype, id, "act.EFTPOSPayment");
        return act != null ? new PaymentImpl(act, this.service, this.domainService, this.practiceService) : null;
    }

    public Refund getRefund(long id) {
        Act act = (Act)this.service.get("act.EFTPOSRefund", id, Act.class);
        return act != null ? new RefundImpl(act, this.service, this.domainService, this.practiceService) : null;
    }

    public Refund getRefund(String archetype, String id) {
        Act act = this.getTransaction(archetype, id, "act.EFTPOSRefund");
        return act != null ? new RefundImpl(act, this.service, this.domainService, this.practiceService) : null;
    }

    public void printMerchantReceipt(Transaction transaction, Receipt receipt) {
        this.monitor.printMerchantReceipt(transaction, receipt);
    }

    public void completed(Transaction transaction) {
        this.monitor.completed(transaction);
    }

    private Act getTransaction(String archetype, String id, String type) {
        if (!TypeHelper.matches((String)archetype, (String)"actIdentity.EFTPOSTransaction*")) {
            throw new IllegalStateException("Invalid transaction id archetype: " + archetype);
        }
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root root = query.from(Act.class, new String[]{type});
        Join identity = root.join("transactionId", archetype);
        identity.on((Expression)builder.equal((Expression)identity.get("identity"), (Object)id));
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        return (Act)this.service.createQuery(query).getFirstResult();
    }
}

