/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.eftpos.internal.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.eftpos.exception.EFTPOSException;
import org.openvpms.eftpos.internal.i18n.EFTPOSMessages;
import org.openvpms.eftpos.transaction.Transaction;
import org.openvpms.eftpos.transaction.TransactionUpdater;

public class TransactionUpdaterImpl
implements TransactionUpdater {
    private final IMObjectBean bean;
    private final boolean printed;
    private final ArchetypeService service;
    private Transaction.Status status;
    private MutableObject<String> message;
    private String transactionIdArchetype;
    private String transactionId;
    private MutableObject<String> cardType;
    private MutableObject<String> authorisationCode;
    private MutableObject<String> responseCode;
    private MutableObject<String> response;
    private MutableObject<String> maskedCardNumber;
    private MutableObject<String> retrievalReferenceNumber;
    private MutableObject<String> systemTraceAuditNumber;
    private List<ReceiptState> receipts = new ArrayList<ReceiptState>();

    public TransactionUpdaterImpl(Transaction transaction, IMObjectBean bean, ArchetypeService service) {
        this.bean = bean;
        this.service = service;
        this.printed = transaction.getTerminal().isReceiptPrinter();
    }

    public TransactionUpdater status(Transaction.Status status) {
        return this.status(status, null);
    }

    public TransactionUpdater status(Transaction.Status status, String message) {
        this.status = status;
        this.message = new MutableObject((Object)message);
        return this;
    }

    public TransactionUpdater transactionId(String archetype, String id) {
        this.transactionIdArchetype = archetype;
        this.transactionId = id;
        return this;
    }

    public TransactionUpdater cardType(String cardType) {
        this.cardType = new MutableObject((Object)cardType);
        return this;
    }

    public TransactionUpdater authorisationCode(String authorisationCode) {
        this.authorisationCode = new MutableObject((Object)authorisationCode);
        return this;
    }

    public TransactionUpdater response(String code, String text) {
        this.responseCode = new MutableObject((Object)code);
        this.response = new MutableObject((Object)text);
        return this;
    }

    public TransactionUpdater maskedCardNumber(String maskedCardNumber) {
        this.maskedCardNumber = new MutableObject((Object)maskedCardNumber);
        return this;
    }

    public TransactionUpdater retrievalReferenceNumber(String retrievalReferenceNumber) {
        this.retrievalReferenceNumber = new MutableObject((Object)retrievalReferenceNumber);
        return this;
    }

    public TransactionUpdater systemTraceAuditNumber(String systemTraceAuditNumber) {
        this.systemTraceAuditNumber = new MutableObject((Object)systemTraceAuditNumber);
        return this;
    }

    public TransactionUpdater addMerchantReceipt(String receipt, boolean signatureRequired) {
        if (!StringUtils.isEmpty((CharSequence)receipt)) {
            this.receipts.add(new ReceiptState(receipt, false, signatureRequired));
        }
        return this;
    }

    public TransactionUpdater addCustomerReceipt(String receipt) {
        if (receipt != null) {
            this.receipts.add(new ReceiptState(receipt, true, false));
        }
        return this;
    }

    public void update() {
        Transaction.Status current = this.getStatus();
        if (current == Transaction.Status.NO_TERMINAL) {
            throw new EFTPOSException(EFTPOSMessages.cannotChangeNoTerminalTransaction());
        }
        ArrayList<IMObject> toSave = new ArrayList<IMObject>();
        boolean updated = false;
        if (this.status != null) {
            if (this.status != current && (current == Transaction.Status.APPROVED || current == Transaction.Status.DECLINED || current == Transaction.Status.ERROR)) {
                throw new EFTPOSException(EFTPOSMessages.cannotChangeStatus(current, this.status));
            }
            this.bean.setValue("status", (Object)this.status.toString());
            updated = true;
        }
        updated |= this.updateIfChanged("message", this.message);
        if (this.transactionId != null) {
            updated = this.updateTransactionId();
        }
        updated |= this.updateIfChanged("cardType", this.cardType);
        updated |= this.updateIdentity(this.authorisationCode, "authorisationCode", "actIdentity.EFTPOSAuthCode");
        updated |= this.updateIfChanged("responseCode", this.responseCode);
        updated |= this.updateIfChanged("response", this.response);
        updated |= this.updateIfChanged("maskedCardNumber", this.maskedCardNumber);
        updated |= this.updateIdentity(this.retrievalReferenceNumber, "retrievalReferenceNumber", "actIdentity.EFTPOSRRN");
        updated |= this.updateIdentity(this.systemTraceAuditNumber, "systemTraceAuditNumber", "actIdentity.EFTPOSSTAN");
        if (!this.receipts.isEmpty()) {
            int sequence = this.getNextReceiptSequence();
            for (ReceiptState state : this.receipts) {
                this.addReceipt(state, sequence++, toSave);
                updated = true;
            }
        }
        this.reset();
        if (updated) {
            toSave.add(0, this.bean.getObject());
            this.service.save(toSave);
        }
    }

    private boolean updateTransactionId() {
        boolean updated = false;
        ActIdentity identity = this.getIdentity(this.transactionIdArchetype, "transactionId");
        if (!identity.isNew()) {
            if (!identity.isA(this.transactionIdArchetype)) {
                throw new EFTPOSException(EFTPOSMessages.differentTxnIdentifierArchetype(identity.getArchetype(), this.transactionIdArchetype));
            }
        } else {
            updated = true;
        }
        return updated |= this.updateIdentity(identity, this.transactionId);
    }

    private boolean updateIdentity(MutableObject<String> id, String node, String archetype) {
        boolean updated = false;
        if (id != null) {
            String value = (String)id.getValue();
            if (value == null) {
                ActIdentity identity = (ActIdentity)this.bean.getObject(node, ActIdentity.class);
                if (identity != null) {
                    this.bean.removeValue(node, (IMObject)identity);
                    updated = true;
                }
            } else {
                ActIdentity identity = this.getIdentity(archetype, node);
                if (identity.isNew()) {
                    updated = true;
                }
                updated |= this.updateIdentity(identity, value);
            }
        }
        return updated;
    }

    private boolean updateIdentity(ActIdentity identity, String value) {
        boolean updated = false;
        if (!Objects.equals(identity.getIdentity(), value)) {
            identity.setIdentity(value);
            updated = true;
        }
        return updated;
    }

    private ActIdentity getIdentity(String archetype, String node) {
        ActIdentity identity = (ActIdentity)this.bean.getObject(node, ActIdentity.class);
        if (identity == null) {
            identity = (ActIdentity)this.service.create(archetype, ActIdentity.class);
            this.bean.addValue(node, (IMObject)identity);
        }
        return identity;
    }

    private Transaction.Status getStatus() {
        Act act = (Act)this.bean.getObject();
        String result = act.getStatus();
        return result != null ? Transaction.Status.valueOf((String)result) : null;
    }

    private void reset() {
        this.status = null;
        this.transactionId = null;
        this.transactionIdArchetype = null;
        this.cardType = null;
        this.authorisationCode = null;
        this.responseCode = null;
        this.response = null;
        this.maskedCardNumber = null;
        this.retrievalReferenceNumber = null;
        this.systemTraceAuditNumber = null;
        this.receipts.clear();
    }

    private boolean updateIfChanged(String name, Object value) {
        boolean updated = false;
        if (!Objects.equals(value, this.bean.getValue(name))) {
            this.bean.setValue(name, value);
            updated = true;
        }
        return updated;
    }

    private boolean updateIfChanged(String name, MutableObject<String> value) {
        return value != null && this.updateIfChanged(name, value.getValue());
    }

    private void addReceipt(ReceiptState receipt, int sequence, List<IMObject> toSave) {
        String archetype = receipt.customer ? "act.EFTPOSReceiptCustomer" : "act.EFTPOSReceiptMerchant";
        DocumentAct act = (DocumentAct)this.service.create(archetype, DocumentAct.class);
        act.setPrinted(this.printed);
        toSave.add((IMObject)act);
        IMObjectBean receiptBean = this.service.getBean((IMObject)act);
        if (receipt.text.length() > receiptBean.getMaxLength("receipt")) {
            TextDocumentHandler handler = new TextDocumentHandler(this.service);
            Document document = handler.create(receiptBean.getDisplayName(), receipt.text);
            act.setDocument((Reference)document.getObjectReference());
            toSave.add((IMObject)document);
        } else {
            receiptBean.setValue("receipt", (Object)receipt.text);
        }
        if (!receipt.customer) {
            receiptBean.setValue("signatureRequired", (Object)receipt.signatureRequired);
        }
        ActRelationship relationship = (ActRelationship)this.bean.addTarget("receipts", (IMObject)act, "transaction");
        relationship.setSequence(sequence);
    }

    private int getNextReceiptSequence() {
        int sequence = 0;
        for (ActRelationship relationship : this.bean.getValues("receipts", ActRelationship.class)) {
            if (relationship.getSequence() < sequence) continue;
            sequence = relationship.getSequence() + 1;
        }
        return sequence;
    }

    private static class ReceiptState {
        private final String text;
        private final boolean customer;
        private final boolean signatureRequired;

        public ReceiptState(String text, boolean customer, boolean signatureRequired) {
            this.text = text;
            this.customer = customer;
            this.signatureRequired = signatureRequired;
        }
    }
}

