/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.eftpos.internal.terminal;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.eftpos.internal.event.EventMonitor;
import org.openvpms.eftpos.terminal.Terminal;
import org.openvpms.eftpos.terminal.TerminalStatus;
import org.openvpms.eftpos.terminal.Terminals;

public class TerminalsImpl
implements Terminals {
    private final ArchetypeService service;
    private final DomainService domainService;
    private final EventMonitor monitor;

    public TerminalsImpl(ArchetypeService service, DomainService domainService, EventMonitor monitor) {
        this.service = service;
        this.domainService = domainService;
        this.monitor = monitor;
    }

    public Terminal getTerminal(Reference reference) {
        return (Terminal)this.domainService.get(reference, Terminal.class);
    }

    public List<Terminal> getTerminals(String archetype, boolean activeOnly) {
        ArrayList<Terminal> result = new ArrayList<Terminal>();
        if (!TypeHelper.matches((String)archetype, (String)"entity.EFTPOSTerminal*")) {
            throw new IllegalStateException("Invalid terminal archetype: " + archetype);
        }
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root root = query.from(Entity.class, new String[]{archetype});
        if (activeOnly) {
            query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
        }
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        for (Entity entity : this.service.createQuery(query).getResultList()) {
            result.add((Terminal)this.domainService.create((IMObject)entity, Terminal.class));
        }
        return result;
    }

    public void terminalUpdated(Terminal terminal, TerminalStatus status) {
        this.monitor.terminalUpdated(terminal, status);
    }
}

