/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.eftpos.internal.event;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import org.openvpms.eftpos.internal.event.EventMonitor;
import org.openvpms.eftpos.terminal.Terminal;
import org.openvpms.eftpos.terminal.TerminalStatus;
import org.openvpms.eftpos.transaction.Receipt;
import org.openvpms.eftpos.transaction.Transaction;

public class EFTPOSEventMonitor
implements EventMonitor {
    private final Map<Terminal, List<WeakReference<Consumer<TerminalStatus>>>> terminals = new HashMap<Terminal, List<WeakReference<Consumer<TerminalStatus>>>>();
    private final Map<Transaction, List<WeakReference<Consumer<Transaction>>>> transactions = new HashMap<Transaction, List<WeakReference<Consumer<Transaction>>>>();
    private final Map<Transaction, List<WeakReference<Consumer<Receipt>>>> print = new HashMap<Transaction, List<WeakReference<Consumer<Receipt>>>>();

    public synchronized void addTerminalListener(Terminal terminal, Consumer<TerminalStatus> listener) {
        this.addListener(terminal, listener, this.terminals);
    }

    public synchronized void removeTerminalListener(Terminal terminal, Consumer<TerminalStatus> listener) {
        this.removeListener(terminal, listener, this.terminals);
    }

    public synchronized void addTransactionListener(Transaction transaction, Consumer<Transaction> listener) {
        this.addListener(transaction, listener, this.transactions);
    }

    public synchronized void removeTransactionListener(Transaction transaction, Consumer<Transaction> listener) {
        this.removeListener(transaction, listener, this.transactions);
    }

    public synchronized void addPrintListener(Transaction transaction, Consumer<Receipt> listener) {
        this.addListener(transaction, listener, this.print);
    }

    public synchronized void removePrintListener(Transaction transaction, Consumer<Receipt> listener) {
        this.removeListener(transaction, listener, this.print);
    }

    @Override
    public void terminalUpdated(Terminal terminal, TerminalStatus status) {
        this.notifyAll(terminal, status, this.terminals);
    }

    @Override
    public void printMerchantReceipt(Transaction transaction, Receipt receipt) {
        this.notifyAll(transaction, receipt, this.print);
    }

    @Override
    public void completed(Transaction transaction) {
        this.notifyAll(transaction, transaction, this.transactions);
    }

    private <K, T> void notifyAll(K key, T value, Map<K, List<WeakReference<Consumer<T>>>> listeners) {
        List<Consumer<T>> matches = this.getListeners(key, listeners);
        for (Consumer<T> listener : matches) {
            listener.accept(value);
        }
    }

    private <K, T> void addListener(K key, Consumer<T> listener, Map<K, List<WeakReference<Consumer<T>>>> listeners) {
        List list = listeners.computeIfAbsent(key, k -> new ArrayList());
        list.add(new WeakReference<Consumer<T>>(listener));
    }

    private <K, T> void removeListener(K key, Consumer<T> listener, Map<K, List<WeakReference<Consumer<T>>>> listeners) {
        List<WeakReference<Consumer<T>>> list = listeners.get(key);
        if (list != null) {
            ListIterator<WeakReference<Consumer<T>>> iterator = list.listIterator();
            while (iterator.hasNext()) {
                WeakReference<Consumer<T>> next = iterator.next();
                Consumer consumer = (Consumer)next.get();
                if (consumer != null && !consumer.equals(listener)) continue;
                iterator.remove();
            }
            if (list.isEmpty()) {
                listeners.remove(key);
            }
        }
    }

    private synchronized <K, T> List<Consumer<T>> getListeners(K key, Map<K, List<WeakReference<Consumer<T>>>> listeners) {
        ArrayList<Consumer<T>> matches = new ArrayList<Consumer<T>>();
        List<WeakReference<Consumer<T>>> list = listeners.get(key);
        if (list != null) {
            ListIterator<WeakReference<Consumer<T>>> iterator = list.listIterator();
            while (iterator.hasNext()) {
                WeakReference<Consumer<T>> next = iterator.next();
                Consumer listener = (Consumer)next.get();
                if (listener == null) {
                    iterator.remove();
                    continue;
                }
                matches.add(listener);
            }
            if (list.isEmpty()) {
                listeners.remove(key);
            }
        }
        return matches;
    }
}

