/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.eftpos.internal.transaction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.SequencedRelationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.practice.Location;
import org.openvpms.eftpos.internal.transaction.ReceiptImpl;
import org.openvpms.eftpos.internal.transaction.TransactionUpdaterImpl;
import org.openvpms.eftpos.terminal.Terminal;
import org.openvpms.eftpos.transaction.Receipt;
import org.openvpms.eftpos.transaction.Transaction;
import org.openvpms.eftpos.transaction.TransactionUpdater;

public class TransactionImpl
implements Transaction {
    private final Act act;
    private final IMObjectBean bean;
    private final ArchetypeService service;
    private final DomainService domainService;
    private final PracticeService practiceService;
    static final String TRANSACTION_ID = "transactionId";
    static final String AUTHORISATION_CODE = "authorisationCode";
    static final String RETRIEVAL_REFERENCE_NUMBER = "retrievalReferenceNumber";
    static final String SYSTEM_TRACE_AUDIT_NUMBER = "systemTraceAuditNumber";

    public TransactionImpl(Act act, ArchetypeService service, DomainService domainService, PracticeService practiceService) {
        this.act = act;
        this.service = service;
        this.bean = service.getBean((IMObject)act);
        this.domainService = domainService;
        this.practiceService = practiceService;
    }

    public long getId() {
        return this.act.getId();
    }

    public long getParentId() {
        ActIdentity identity = (ActIdentity)this.bean.getObject("parentId", ActIdentity.class);
        return identity != null ? Long.parseLong(identity.getIdentity()) : -1L;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransactionImpl) {
            return this.act.equals(((TransactionImpl)obj).act);
        }
        return false;
    }

    public int hashCode() {
        return this.act.hashCode();
    }

    public String getTransactionId() {
        ActIdentity identity = this.getTransactionIdentity();
        return identity != null ? identity.getIdentity() : null;
    }

    public ActIdentity getTransactionIdentity() {
        return this.getActIdentity(TRANSACTION_ID);
    }

    public Transaction.Status getStatus() {
        return Transaction.Status.valueOf((String)this.act.getStatus());
    }

    public String getMessage() {
        return this.bean.getString("message");
    }

    public boolean isComplete() {
        Transaction.Status status = this.getStatus();
        return status == Transaction.Status.APPROVED || status == Transaction.Status.DECLINED || status == Transaction.Status.ERROR || status == Transaction.Status.NO_TERMINAL;
    }

    public Party getCustomer() {
        return (Party)this.bean.getTarget("customer", Party.class);
    }

    public Terminal getTerminal() {
        Terminal result;
        if (this.getStatus() == Transaction.Status.NO_TERMINAL) {
            result = null;
        } else {
            Entity terminal = (Entity)this.bean.getTarget("terminal", Entity.class);
            if (terminal == null) {
                throw new IllegalStateException("Transaction has no terminal");
            }
            result = (Terminal)this.domainService.create((IMObject)terminal, Terminal.class);
        }
        return result;
    }

    public Location getLocation() {
        Party location = (Party)this.bean.getTarget("location", Party.class);
        if (location == null) {
            throw new IllegalStateException("Transaction has no location");
        }
        return (Location)this.domainService.create((IMObject)location, Location.class);
    }

    public BigDecimal getAmount() {
        return this.bean.getBigDecimal("amount", BigDecimal.ZERO);
    }

    public String getCurrencyCode() {
        Currency currency = this.practiceService.getCurrency();
        if (currency == null) {
            throw new IllegalStateException("No practice currency");
        }
        return currency.getCode();
    }

    public String getCardType() {
        return this.bean.getString("cardType");
    }

    public String getAuthorisationCode() {
        return this.getIdentity(AUTHORISATION_CODE);
    }

    public String getResponseCode() {
        return this.bean.getString("responseCode");
    }

    public String getResponse() {
        return this.bean.getString("response");
    }

    public String getMaskedCardNumber() {
        return this.bean.getString("maskedCardNumber");
    }

    public String getRetrievalReferenceNumber() {
        return this.getIdentity(RETRIEVAL_REFERENCE_NUMBER);
    }

    public String getSystemTraceAuditNumber() {
        return this.getIdentity(SYSTEM_TRACE_AUDIT_NUMBER);
    }

    public List<Receipt> getMerchantReceipts() {
        return this.getReceipts("act.EFTPOSReceiptMerchant");
    }

    public List<Receipt> getCustomerReceipts() {
        return this.getReceipts("act.EFTPOSReceiptCustomer");
    }

    public TransactionUpdater state() {
        return new TransactionUpdaterImpl(this, this.bean, this.service);
    }

    protected IMObjectBean getBean() {
        return this.bean;
    }

    protected DomainService getDomainService() {
        return this.domainService;
    }

    private String getIdentity(String node) {
        ActIdentity identity = this.getActIdentity(node);
        return identity != null ? identity.getIdentity() : null;
    }

    private ActIdentity getActIdentity(String node) {
        return (ActIdentity)this.bean.getObject(node, ActIdentity.class);
    }

    private List<Receipt> getReceipts(String archetype) {
        ArrayList<Receipt> result = new ArrayList<Receipt>();
        Policy policy = Policies.newPolicy(SequencedRelationship.class).anyObject().predicate(Predicates.targetIsA((String[])new String[]{archetype})).orderBySequence().build();
        for (DocumentAct receipt : this.bean.getTargets("receipts", DocumentAct.class, policy)) {
            result.add(new ReceiptImpl(receipt, this.service));
        }
        return result;
    }
}

