/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.eftpos.internal.transaction;

import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.component.business.domain.im.act.DocumentActDecorator;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.eftpos.transaction.Receipt;

public class ReceiptImpl
extends DocumentActDecorator
implements Receipt {
    private final String receipt;
    private final boolean isSignaturedRequired;
    private static final String SIGNATURE_REQUIRED = "signatureRequired";

    public ReceiptImpl(DocumentAct act, ArchetypeService service) {
        super(act);
        Document document;
        String text = null;
        if (act.getDocument() != null && (document = (Document)service.get(act.getDocument(), Document.class)) != null) {
            TextDocumentHandler handler = new TextDocumentHandler(service);
            text = handler.toString(document);
        }
        IMObjectBean bean = service.getBean((IMObject)act);
        if (text == null) {
            text = bean.getString("receipt");
        }
        this.receipt = text;
        this.isSignaturedRequired = bean.hasNode(SIGNATURE_REQUIRED) && bean.getBoolean(SIGNATURE_REQUIRED);
    }

    public String getReceipt() {
        return this.receipt;
    }

    public boolean isSignatureRequired() {
        return this.isSignaturedRequired;
    }
}

