/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.eftpos.internal.service;

import java.util.List;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.eftpos.exception.EFTPOSException;
import org.openvpms.eftpos.internal.i18n.EFTPOSMessages;
import org.openvpms.eftpos.service.EFTPOSService;
import org.openvpms.plugin.manager.PluginManager;

public class EFTPOSServices {
    private final PluginManager manager;

    public EFTPOSServices(PluginManager manager) {
        this.manager = manager;
    }

    public EFTPOSService getService(Entity terminal) {
        EFTPOSService result = null;
        List services = this.manager.getServices(EFTPOSService.class);
        String archetype = terminal.getArchetype();
        for (EFTPOSService service : services) {
            if (!archetype.equals(service.getTerminalArchetype())) continue;
            result = service;
            break;
        }
        if (result == null) {
            throw new EFTPOSException(EFTPOSMessages.serviceUnavailable(terminal.getName()));
        }
        return result;
    }
}

