/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.eftpos.internal.transaction;

import java.math.BigDecimal;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class EFTPOSTransactionFactory {
    private final ArchetypeService service;

    public EFTPOSTransactionFactory(ArchetypeService service) {
        this.service = service;
    }

    public FinancialAct createPayment(FinancialAct parentPayment, BigDecimal amount, BigDecimal cashout, Entity terminal, Party location) {
        return this.createTransaction(parentPayment, "act.EFTPOSPayment", amount, cashout, null, terminal, location);
    }

    public FinancialAct createRefund(FinancialAct parentRefund, BigDecimal amount, Entity terminal, Party location) {
        return this.createTransaction(parentRefund, "act.EFTPOSRefund", amount, null, null, terminal, location);
    }

    public FinancialAct createNoTerminalPayment(FinancialAct parentPayment, BigDecimal amount, BigDecimal cashout, Party location) {
        return this.createTransaction(parentPayment, "act.EFTPOSPayment", amount, cashout, "NO_TERMINAL", null, location);
    }

    public FinancialAct createNoTerminalRefund(FinancialAct parentRefund, BigDecimal amount, Party location) {
        return this.createTransaction(parentRefund, "act.EFTPOSRefund", amount, null, "NO_TERMINAL", null, location);
    }

    private FinancialAct createTransaction(FinancialAct parent, String archetype, BigDecimal amount, BigDecimal cashout, String status, Entity terminal, Party location) {
        if (parent.isNew()) {
            throw new IllegalStateException("Parent act must be saved");
        }
        IMObjectBean parentBean = this.service.getBean((IMObject)parent);
        Reference customer = parentBean.getTargetRef("customer");
        if (customer == null) {
            throw new IllegalStateException("Parent act has no customer");
        }
        FinancialAct act = (FinancialAct)this.service.create(archetype, FinancialAct.class);
        ActIdentity identity = (ActIdentity)this.service.create("actIdentity.EFTPOSParentId", ActIdentity.class);
        identity.setIdentity(Long.toString(parent.getId()));
        act.addIdentity(identity);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setValue("amount", (Object)amount);
        if (cashout != null) {
            bean.setValue("cashout", (Object)cashout);
        }
        if (status != null) {
            act.setStatus(status);
        }
        bean.setTarget("customer", customer);
        if (terminal != null) {
            bean.setTarget("terminal", (IMObject)terminal);
        }
        bean.setTarget("location", (IMObject)location);
        return act;
    }
}

