/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.supplier;

import java.time.OffsetDateTime;
import java.util.Date;
import java.util.function.Predicate;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.party.ContactablePartyImpl;
import org.openvpms.domain.supplier.ReferralPractice;
import org.openvpms.domain.supplier.ReferralVet;

public class ReferralVetImpl
extends ContactablePartyImpl
implements ReferralVet {
    public ReferralVetImpl(Party peer, PartyRules rules, DomainService service) {
        super(peer, rules, service);
    }

    public ReferralVetImpl(IMObjectBean bean, PartyRules rules, DomainService service) {
        super(bean, rules, service);
    }

    public String getTitle() {
        Lookup title = this.getBean().getLookup("title");
        return title != null ? title.getName() : null;
    }

    public String getFirstName() {
        return this.getBean().getString("firstName");
    }

    public String getLastName() {
        return this.getBean().getString("lastName");
    }

    public ReferralPractice getPractice() {
        return this.getPractice(new Date());
    }

    public ReferralPractice getPractice(OffsetDateTime date) {
        return this.getPractice(DateRules.toDate((OffsetDateTime)date));
    }

    private ReferralPractice getPractice(Date date) {
        Party practice = (Party)this.getBean().getSource("practices", Party.class, Policies.any((Predicate)Predicates.activeAt((Date)date)));
        return practice != null ? this.getService().create(practice, ReferralPractice.class) : null;
    }
}

