/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.laboratory;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.business.domain.im.common.BeanEntityDecorator;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Identity;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.laboratory.Device;
import org.openvpms.domain.laboratory.InvestigationType;
import org.openvpms.domain.laboratory.Laboratory;

public class InvestigationTypeImpl
extends BeanEntityDecorator
implements InvestigationType {
    private final DomainService service;

    public InvestigationTypeImpl(Entity entity, DomainService service) {
        super(entity, (IMObjectBeanFactory)service);
        this.service = service;
    }

    public InvestigationTypeImpl(IMObjectBean bean, DomainService service) {
        super(bean);
        this.service = service;
    }

    public String getTypeId() {
        Identity identity = this.getTypeIdentity();
        return identity != null ? identity.getIdentity() : null;
    }

    public Identity getTypeIdentity() {
        return (Identity)this.getBean().getObject("typeId", Identity.class);
    }

    public Laboratory getLaboratory() {
        Laboratory result = null;
        Entity laboratory = (Entity)this.getBean().getTarget("laboratory", Entity.class);
        if (laboratory != null) {
            result = this.service.create(laboratory, Laboratory.class);
        }
        return result;
    }

    public List<Device> getDevices() {
        ArrayList<Device> result = new ArrayList<Device>();
        IMObjectBean bean = this.getBean();
        for (Entity entity : bean.getTargets("devices", Entity.class)) {
            result.add(this.service.create(entity, Device.class));
        }
        return result;
    }
}

