/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.customer.transaction;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.customer.transaction.Transaction;
import org.openvpms.domain.customer.transaction.TransactionItem;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.practice.Location;

public class TransactionImpl<T extends TransactionItem>
implements Transaction<T> {
    private final FinancialAct transaction;
    private final IMObjectBean bean;
    private final Class<T> itemType;
    private final DomainService domainService;
    private Customer customer;
    private List<T> items;
    private Location location;
    private static final String ITEMS = "items";

    public TransactionImpl(FinancialAct transaction, Class<T> itemType, DomainService domainService) {
        this.transaction = transaction;
        this.bean = domainService.getBean((IMObject)transaction);
        this.itemType = itemType;
        this.domainService = domainService;
    }

    protected TransactionImpl(IMObjectBean bean, Class<T> itemType, DomainService domainService) {
        this.transaction = (FinancialAct)bean.getObject(FinancialAct.class);
        this.bean = bean;
        this.itemType = itemType;
        this.domainService = domainService;
    }

    public long getId() {
        return this.transaction.getId();
    }

    public OffsetDateTime getDate() {
        return DateRules.toOffsetDateTime((Date)this.transaction.getActivityStartTime());
    }

    public Customer getCustomer() {
        Party party;
        if (this.customer == null && (party = (Party)this.getBean().getTarget("customer", Party.class)) != null) {
            this.customer = this.domainService.create(party, Customer.class);
        }
        return this.customer;
    }

    public List<T> getItems() {
        if (this.items == null) {
            if (this.bean.hasNode(ITEMS) && this.itemType != null) {
                ArrayList<T> matches = new ArrayList<T>();
                List acts = this.bean.getTargets(ITEMS, FinancialAct.class);
                for (FinancialAct act : acts) {
                    matches.add(this.domainService.create(act, this.itemType));
                }
                this.items = Collections.unmodifiableList(matches);
            } else {
                this.items = Collections.emptyList();
            }
        }
        return this.items;
    }

    public BigDecimal getTotal() {
        return this.transaction.getTotal();
    }

    public boolean isFinalised() {
        return "POSTED".equals(this.transaction.getStatus());
    }

    public Location getLocation() {
        Party party;
        if (this.location == null && (party = (Party)this.getBean().getTarget("location", Party.class)) != null) {
            this.location = this.domainService.create(party, Location.class);
        }
        return this.location;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransactionImpl) {
            return this.transaction.equals(((TransactionImpl)obj).transaction);
        }
        return false;
    }

    public int hashCode() {
        return this.transaction.hashCode();
    }

    protected FinancialAct getTransaction() {
        return this.transaction;
    }

    protected IMObjectBean getBean() {
        return this.bean;
    }
}

