/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.patient;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.service.patient.PatientBuilderImpl;
import org.openvpms.domain.internal.service.patient.PatientServices;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.service.patient.PatientBuilder;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientBuilderImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private DomainService domainService;
    @Autowired
    private PatientServices patientServices;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;

    @Test
    public void testNewPatient() {
        Lookup species = this.lookupFactory.getSpecies("CANINE");
        Lookup breed = this.lookupFactory.getBreed("KELPIE");
        LocalDate dateOfBirth = DateRules.toLocalDate((Date)TestHelper.getDate((String)"2020-01-01"));
        LocalDate dateOfDeath = DateRules.toLocalDate((Date)TestHelper.getDate((String)"2023-01-01"));
        Customer customer = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer(), Customer.class);
        Patient patient = this.getBuilder().name("Fido").species(species).breed(breed).sex(Patient.Sex.FEMALE).desexed(true).dateOfBirth(dateOfBirth).deceased(true).dateOfDeath(dateOfDeath).colour("Black").owner(customer).microchip("123456").active(false).build();
        Assert.assertEquals((Object)"Fido", (Object)patient.getName());
        Assert.assertEquals((Object)species.getCode(), (Object)patient.getSpeciesCode());
        Assert.assertEquals((Object)breed.getCode(), (Object)patient.getBreedCode());
        Assert.assertEquals((Object)Patient.Sex.FEMALE, (Object)patient.getSex());
        Assert.assertTrue((boolean)patient.isDesexed());
        Assert.assertEquals((Object)dateOfBirth, (Object)patient.getDateOfBirth());
        Assert.assertTrue((boolean)patient.isDeceased());
        Assert.assertEquals((Object)dateOfDeath, (Object)patient.getDateOfDeath());
        Assert.assertEquals((Object)"Black", (Object)patient.getColourName());
        Assert.assertEquals((Object)customer, (Object)patient.getOwner());
        Assert.assertEquals((Object)"123456", (Object)patient.getMicrochip().getIdentity());
        Assert.assertFalse((boolean)patient.isActive());
    }

    @Test
    public void testUpdatePatient() {
        Lookup species1 = this.lookupFactory.getSpecies("CANINE");
        Lookup breed1 = this.lookupFactory.getBreed("KELPIE");
        Lookup species2 = this.lookupFactory.getSpecies("FELINE");
        Lookup breed2 = this.lookupFactory.getBreed("BIRMAN");
        LocalDate dateOfBirth1 = DateRules.toLocalDate((Date)TestHelper.getDate((String)"2020-01-01"));
        LocalDate dateOfDeath1 = DateRules.toLocalDate((Date)TestHelper.getDate((String)"2023-01-01"));
        LocalDate dateOfBirth2 = DateRules.toLocalDate((Date)TestHelper.getDate((String)"2020-01-02"));
        Customer customer1 = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer(), Customer.class);
        Customer customer2 = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer(), Customer.class);
        Patient patient1 = this.getBuilder().name("Fido").species(species1).breed(breed1).sex(Patient.Sex.FEMALE).desexed(true).dateOfBirth(dateOfBirth1).deceased(true).dateOfDeath(dateOfDeath1).colour("Black").owner(customer1).microchip("123456").active(false).build();
        this.getBuilder((Party)patient1).name("Milo").species(species2).breed(breed2).sex(Patient.Sex.MALE).desexed(false).dateOfBirth(dateOfBirth2).deceased(false).dateOfDeath(null).colour("Brown").owner(customer2).microchip("987654").active(true).build();
        Patient patient2 = this.reload(patient1);
        Assert.assertEquals((Object)"Milo", (Object)patient2.getName());
        Assert.assertEquals((Object)species2.getCode(), (Object)patient2.getSpeciesCode());
        Assert.assertEquals((Object)breed2.getCode(), (Object)patient2.getBreedCode());
        Assert.assertEquals((Object)Patient.Sex.MALE, (Object)patient2.getSex());
        Assert.assertFalse((boolean)patient2.isDesexed());
        Assert.assertEquals((Object)dateOfBirth2, (Object)patient2.getDateOfBirth());
        Assert.assertFalse((boolean)patient2.isDeceased());
        Assert.assertEquals((Object)"Brown", (Object)patient2.getColourName());
        Assert.assertEquals((Object)customer2, (Object)patient2.getOwner());
        Assert.assertEquals((Object)"987654", (Object)patient2.getMicrochip().getIdentity());
        Assert.assertTrue((boolean)patient2.isActive());
    }

    @Test
    public void testChangeOwnership() {
        Lookup species = this.lookupFactory.getSpecies("CANINE");
        Lookup breed = this.lookupFactory.getBreed("KELPIE");
        Customer customer1 = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer(), Customer.class);
        Customer customer2 = (Customer)this.domainService.create((IMObject)this.customerFactory.createCustomer(), Customer.class);
        Patient patient1 = this.getBuilder().name("Fido").species(species).breed(breed).build();
        Assert.assertNull((Object)patient1.getOwner());
        this.getBuilder((Party)patient1).owner(customer1).build();
        Assert.assertEquals((Object)customer1, (Object)patient1.getOwner());
        this.getBuilder((Party)patient1).build();
        Assert.assertEquals((Object)customer1, (Object)patient1.getOwner());
        this.getBuilder((Party)patient1).owner(customer2).build();
        Assert.assertEquals((Object)customer2, (Object)patient1.getOwner());
        this.getBuilder((Party)patient1).owner(null).build();
        Assert.assertNull((Object)patient1.getOwner());
        Patient patient2 = this.reload(patient1);
        Assert.assertNull((Object)patient2.getOwner());
        List relationships = patient2.getEntityRelationships().stream().filter(relationship -> relationship.isA("entityRelationship.patientOwner")).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)relationships.size());
    }

    @Test
    public void testChangeMicrochip() {
        Lookup species = this.lookupFactory.getSpecies("CANINE");
        Lookup breed = this.lookupFactory.getBreed("KELPIE");
        Patient patient1 = this.getBuilder().name("Fido").species(species).breed(breed).build();
        Assert.assertNull((Object)patient1.getMicrochip());
        this.getBuilder((Party)patient1).microchip("1").build();
        Assert.assertEquals((Object)"1", (Object)patient1.getMicrochip().getIdentity());
        this.getBuilder((Party)patient1).build();
        Assert.assertEquals((Object)"1", (Object)patient1.getMicrochip().getIdentity());
        this.getBuilder((Party)patient1).microchip("2").build();
        Assert.assertEquals((Object)"2", (Object)patient1.getMicrochip().getIdentity());
        this.getBuilder((Party)patient1).microchip(null).build();
        Assert.assertNull((Object)patient1.getMicrochip());
        Patient patient2 = this.reload(patient1);
        Assert.assertNull((Object)patient2.getMicrochip());
    }

    private PatientBuilder getBuilder() {
        return new PatientBuilderImpl(this.patientServices);
    }

    private PatientBuilder getBuilder(Party patient) {
        return new PatientBuilderImpl(patient, this.patientServices);
    }

    private Patient reload(Patient patient) {
        return (Patient)this.domainService.create(this.get(patient.getObjectReference()), Patient.class);
    }
}

